`include "def.h"
module mipse(
input clk, rst_n,
input [`DATA_W*4-1:0] instr,
input [`DATA_W-1:0] readdata2, readdata3,
output reg [`DATA_W-1:0] pc,
output [`DATA_W-1:0] aluout2, aluout3,
output [`DATA_W-1:0] writedata2, writedata3,
output memwrite2, memwrite3);

reg [`DATA_W-1:0] pcplus4D ;
wire [`DATA_W-1:0] pcplus4F ;
wire [`DATA_W-1:0] pcbranchD ;
reg [`DATA_W*4-1:0] instrD ;
wire btakenD;

assign pcplus4F = pc + 4;

always @(posedge clk or negedge rst_n) 
begin 
   if(!rst_n) instrD <= 0;
   else instrD <= instr;
end

always @(posedge clk or negedge rst_n)
begin
   if(!rst_n) pcplus4D <= 0;
      else pcplus4D <= pcplus4F;
	  end

always @(posedge clk or negedge rst_n)
 begin
     if(!rst_n) pc <= 0;
	    else if(btakenD)
		     pc <= {pcbranchD[29:0],2'b00};
	    else 
		     pc <= pcplus4F;
 end

/*  Instruction Decorder Stage */

wire [`REG_W-1:0] rsD0, rdD0, rtD0 ;
wire [`REG_W-1:0] rsD1, rdD1, rtD1 ;
wire [`REG_W-1:0] rsD2, rdD2, rtD2 ;
wire [`REG_W-1:0] rsD3, rdD3, rtD3 ;
wire [`OPCODE_W-1:0] opcodeD0, opcodeD1, opcodeD2, opcodeD3;
wire [`SHAMT_W-1:0] shamtD0, shamtD1, shamtD2, shamtD3;
wire [`OPCODE_W-1:0] funcD0, funcD1, funcD2, funcD3;
wire sw_opD2, addi_opD0, lw_opD2, alu_opD0, lui_opD0;
wire sw_opD3, addi_opD1, lw_opD3, alu_opD1, lui_opD1;
wire lui_op0, lui_op1, ori_opD0, ori_opD1, beq_opD, bne_opD, branchD;

wire regwriteD0, memtoregD0;
wire [`OPCODE_W-1:0] alucomD0;
wire [`IMM_W-1:0] immD0;
wire [`DATA_W-1:0] signimmD0;
reg [`REG_W-1:0] writeregW0;
wire [`DATA_W-1:0] rd1D0, rd2D0;
wire [`LANE_W-1:0] memwriteD0;
reg [`REG_W-1:0] rtE0, rdE0;
reg [`DATA_W-1:0] signimmE0, srcaE0, writedataE0;
wire [`DATA_W-1:0] resultW0;
reg [`OPCODE_W-1:0] alucomE0;
reg regwriteE0, memtoregE0, alusrcE0, regdstE0;
reg memwriteE0;
reg regwriteW0;

wire regwriteD1, memtoregD1;
wire [`OPCODE_W-1:0] alucomD1;
wire [`IMM_W-1:0] immD1;
wire [`DATA_W-1:0] signimmD1;
reg [`REG_W-1:0] writeregW1;
wire [`DATA_W-1:0] rd1D1, rd2D1;
wire [`LANE_W-1:0] memwriteD1;
reg [`REG_W-1:0] rtE1, rdE1;
reg [`DATA_W-1:0] signimmE1, srcaE1, writedataE1;
wire [`DATA_W-1:0] resultW1;
reg [`OPCODE_W-1:0] alucomE1;
reg regwriteE1, memtoregE1, alusrcE1, regdstE1;
reg memwriteE1;
reg regwriteW1;

wire regwriteD2, memtoregD2;
wire [`OPCODE_W-1:0] alucomD2;
wire [`IMM_W-1:0] immD2;
wire [`DATA_W-1:0] signimmD2;
reg [`REG_W-1:0] writeregW2;
wire [`DATA_W-1:0] rd1D2, rd2D2;
wire [`LANE_W-1:0] memwriteD2;
reg [`REG_W-1:0] rtE2, rdE2;
reg [`DATA_W-1:0] signimmE2, srcaE2, writedataE2;
wire [`DATA_W-1:0] resultW2;
reg [`OPCODE_W-1:0] alucomE2;
reg regwriteE2, memtoregE2, alusrcE2, regdstE2;
reg memwriteE2;
reg regwriteW2;

wire regwriteD3, memtoregD3;
wire [`OPCODE_W-1:0] alucomD3;
wire [`IMM_W-1:0] immD3;
wire [`DATA_W-1:0] signimmD3;
reg [`REG_W-1:0] writeregW3;
wire [`DATA_W-1:0] rd1D3, rd2D3;
wire [`LANE_W-1:0] memwriteD3;
reg [`REG_W-1:0] rtE3, rdE3;
reg [`DATA_W-1:0] signimmE3, srcaE3, writedataE3;
wire [`DATA_W-1:0] resultW3;
reg [`OPCODE_W-1:0] alucomE3;
reg regwriteE3, memtoregE3, alusrcE3, regdstE3;
reg memwriteE3;
reg regwriteW3;

assign {opcodeD0, rsD0, rtD0, rdD0, shamtD0, funcD0} = instrD[`DATA_W*4-1:`DATA_W*3];
assign {opcodeD1, rsD1, rtD1, rdD1, shamtD1, funcD1} = instrD[`DATA_W*3-1:`DATA_W*2];
assign {opcodeD2, rsD2, rtD2, rdD2, shamtD2, funcD2} = instrD[`DATA_W*2-1:`DATA_W];
assign {opcodeD3, rsD3, rtD3, rdD3, shamtD3, funcD3} = instrD[`DATA_W-1:0];

assign immD0 = instrD[`DATA_W*3+`IMM_W-1:`DATA_W*3];
assign immD1 = instrD[`DATA_W*2+`IMM_W-1:`DATA_W*2];
assign immD2 = instrD[`DATA_W+`IMM_W-1:`DATA_W];
assign immD3 = instrD[`IMM_W-1:0];

assign sw_opD2 = (opcodeD2 == `OP_SW);
assign lw_opD2 = (opcodeD2 == `OP_LW);
assign sw_opD3 = (opcodeD3 == `OP_SW);
assign lw_opD3 = (opcodeD3 == `OP_LW);
assign alu_opD0 = (opcodeD0 == `OP_REG) & (
     (funcD0[5:3] == 3'b100)|(funcD0 == `FUNC_MULT) );
assign addi_opD0 = (opcodeD0 == `OP_ADDI);
assign ori_opD0 = (opcodeD0 == `OP_ORI);
assign lui_opD0 = (opcodeD0 == `OP_LUI);
assign alu_opD1 = (opcodeD1== `OP_REG) & (
     (funcD1[5:3] == 3'b100)|(funcD1 == `FUNC_MULT) );
assign addi_opD1 = (opcodeD1 == `OP_ADDI);
assign ori_opD1 = (opcodeD1 == `OP_ORI);
assign lui_opD1 = (opcodeD1 == `OP_LUI);

assign beq_opD = (opcodeD0 == `OP_BEQ);
assign bne_opD = (opcodeD0 == `OP_BNE);
assign branchD = beq_opD | bne_opD;

assign memwriteD2 = sw_opD2 ;
assign memwriteD3 = sw_opD3 ;

rfile rfile_1(.clk(clk), .rd1(rd1D0), .a1(rsD0), .rd2(rd2D0), .a2(rtD0), 
	.wd3(resultW0), .a3(writeregW0), .we3(regwriteW0),
	.rd4(rd1D1), .a4(rsD1), .rd5(rd2D1), .a5(rtD1), 
	.wd6(resultW1), .a6(writeregW1), .we6(regwriteW1),
	.rd7(rd1D2), .a7(rsD2), .rd8(rd2D2), .a8(rtD2), 
	.wd9(resultW2), .a9(writeregW2), .we9(regwriteW2),
	.rd10(rd1D3), .a10(rsD3), .rd11(rd2D3), .a11(rtD3), 
	.wd12(resultW3), .a12(writeregW3), .we12(regwriteW3) );

assign alucomD0 = addi_opD0 ?  `ALU_ADD: 
		ori_opD0 ? `ALU_OR: 
		lui_opD0 ? `ALU_THB: funcD0;

assign alucomD1 = addi_opD1 ?  `ALU_ADD: 
		ori_opD1 ? `ALU_OR: 
		lui_opD1 ? `ALU_THB: funcD1;

assign regwriteD0 = alu_opD0 | lui_opD0 | addi_opD0 | ori_opD0 ;
assign regwriteD1 = alu_opD1 | lui_opD1 | addi_opD1 | ori_opD1 ;
assign regwriteD2 = lw_opD2;
assign regwriteD3 = lw_opD3;
assign memtoregD2 = lw_opD2 ;
assign memtoregD3 = lw_opD3 ;

assign signimmD0 = ori_opD0 ?  {16'b0,immD0} :
                lui_opD0 ? {immD0, 16'b0} :
				                {{16{immD0[15]}},immD0} ;
assign signimmD1 = ori_opD1 ?  {16'b0,immD1} :
                lui_opD1 ? {immD1, 16'b0} :
				                {{16{immD1[15]}},immD1} ;
assign signimmD2 = {{16{immD2[15]}},immD2} ;
assign signimmD3 = {{16{immD3[15]}},immD3} ;

// Branch
assign btakenD = beq_opD & (rd1D0 == rd2D0) | bne_opD & (rd1D0 != rd2D0);
assign pcbranchD = {{2'b00,pcplus4D[31:2]} + {{2{signimmD0[31]}},signimmD0[31:2]}};

// Pipeline data register 
always @(posedge clk) begin
	rtE0 <= rtD0;
	rdE0 <= rdD0;
	srcaE0 <= rd1D0;
	writedataE0 <= rd2D0; 
	alucomE0 <= alucomD0;
	memtoregE0 <= memtoregD0;
	alusrcE0 <= ~alu_opD0;
	regdstE0 <= alu_opD0; 
	signimmE0 <= signimmD0;
end

always @(posedge clk) begin
	rtE1 <= rtD1;
	rdE1 <= rdD1;
	srcaE1 <= rd1D1;
	writedataE1 <= rd2D1; 
	alucomE1 <= alucomD1;
	memtoregE1 <= memtoregD1;
	alusrcE1 <= ~alu_opD1;
	regdstE1 <= alu_opD1; 
	signimmE1 <= signimmD1;
end

always @(posedge clk) begin
	rtE2 <= rtD2;
	rdE2 <= rdD2;
	srcaE2 <= rd1D2;
	writedataE2 <= rd2D2; 
	memtoregE2 <= memtoregD2;
	signimmE2 <= signimmD2;
end

always @(posedge clk) begin
	rtE3 <= rtD3;
	rdE3 <= rdD3;
	srcaE3 <= rd1D3;
	writedataE3 <= rd2D3; 
	memtoregE3 <= memtoregD3;
	signimmE3 <= signimmD3;
end

// Pipeline control register with reset
always @(posedge clk or negedge rst_n) begin
	if(!rst_n) begin
		regwriteE0 <= 0;
		regwriteE1 <= 0;
		regwriteE2 <= 0;
		regwriteE3 <= 0;
		memwriteE2 <= 0;
		memwriteE3 <= 0; end
	else begin
		regwriteE0 <= regwriteD0;
		regwriteE1 <= regwriteD1;
		regwriteE2 <= regwriteD2;
		regwriteE3 <= regwriteD3;
		memwriteE2 <= memwriteD2;
		memwriteE3 <= memwriteD3; end
end

/* Execution Stage */

wire [`DATA_W-1:0] srcbE0, aluoutE0;
wire [`DATA_W-1:0] srcbE1, aluoutE1;
wire [`DATA_W-1:0] aluoutE2;
wire [`DATA_W-1:0] aluoutE3;
wire [`REG_W-1:0] writeregE0, writeregE1;
reg [`REG_W-1:0] writeregM0, writeregM1;
reg [`REG_W-1:0] writeregM2, writeregM3;
reg [`DATA_W-1:0] writedataM0, aluoutM0;
reg [`DATA_W-1:0] writedataM1, aluoutM1;
reg [`DATA_W-1:0] writedataM2, aluoutM2;
reg [`DATA_W-1:0] writedataM3, aluoutM3;
reg regwriteM0, regwriteM1, regwriteM2, regwriteM3;
reg memtoregM2, memtoregM3, memwriteM2, memwriteM3;

assign srcbE0 = alusrcE0 ? signimmE0 : writedataE0;
assign writeregE0 = regdstE0 ? rdE0: rtE0;
assign srcbE1 = alusrcE1 ? signimmE1 : writedataE1;
assign writeregE1 = regdstE1 ? rdE1: rtE1;

alu alu_0(.a(srcaE0), .b(srcbE0), .s(alucomE0), .y(aluoutE0));
alu alu_1(.a(srcaE1), .b(srcbE1), .s(alucomE1), .y(aluoutE1));
assign aluoutE2 = srcaE2 + signimmE2;
assign aluoutE3 = srcaE3 + signimmE3;

// Pipeline register 
always @(posedge clk) begin
	aluoutM0 <= aluoutE0;
	writeregM0 <= writeregE0;
	aluoutM1 <= aluoutE1;
	writeregM1 <= writeregE1;
	aluoutM2 <= aluoutE2;
	aluoutM3 <= aluoutE3;

	memtoregM2 <= memtoregE2;
	writedataM2 <= writedataE2;
	writeregM2 <= rtE2;
	memtoregM3 <= memtoregE3;
	writedataM3 <= writedataE3;
	writeregM3 <= rtE3;
end

// Pipeline control register with reset
always @(posedge clk or negedge rst_n) begin
	if(!rst_n) begin
		regwriteM0 <= 0;
		regwriteM1 <= 0;
		regwriteM2 <= 0;
		regwriteM3 <= 0;
		memwriteM2 <= 0; 
		memwriteM3 <= 0; end
	else begin
		regwriteM0 <= regwriteE0;
		regwriteM1 <= regwriteE1;
		regwriteM2 <= regwriteE2;
		regwriteM3 <= regwriteE3;
		memwriteM2 <= memwriteE2;
		memwriteM3 <= memwriteE3; end
end

/* Memory Stage */
reg [`DATA_W-1:0] aluoutW0, aluoutW1;
reg [`DATA_W-1:0] readdataW2, aluoutW2;
reg [`DATA_W-1:0] readdataW3, aluoutW3;
reg memtoregW2, memtoregW3;
assign aluout2 = aluoutM2;
assign writedata2 = writedataM2;
assign memwrite2 = memwriteM2;
assign aluout3 = aluoutM3;
assign writedata3 = writedataM3;
assign memwrite3 = memwriteM3;

always @(posedge clk) begin
	aluoutW0 <= aluoutM0;
	aluoutW1 <= aluoutM1;
	writeregW0 <= writeregM0;
	writeregW1 <= writeregM1;
	readdataW2 <= readdata2;
	readdataW3 <= readdata3;
	memtoregW2 <= memtoregM2;
	writeregW2 <= writeregM2;
	memtoregW3 <= memtoregM3;
	writeregW3 <= writeregM3;
end

always @(posedge clk or negedge rst_n) begin
	if(!rst_n)  begin
		regwriteW0 <= 0;
		regwriteW1 <= 0;
		regwriteW2 <= 0;
		regwriteW3 <= 0; end
	else  begin
		regwriteW0 <= regwriteM0;
		regwriteW1 <= regwriteM1;
		regwriteW2 <= regwriteM2;
		regwriteW3 <= regwriteM3; end
end

/* Write Back Stage */
assign resultW0 = aluoutW0;
assign resultW1 = aluoutW1;
assign resultW2 = readdataW2;
assign resultW3 = readdataW3;

endmodule
