`include "def.h"
module rfile (
 input clk,
 input [`REG_W-1:0] a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12,
 output [`DATA_W-1:0] rd1, rd2, rd4, rd5, rd7, rd8, rd10, rd11,
 input [`DATA_W-1:0] wd3, wd6, wd9, wd12,
 input we3, we6, we9, we12);

	reg [`DATA_W-1:0] rf[0:`REG-1];

	assign rd1 = |a1 == 0 ? 0 : rf[a1];
	assign rd2 = |a2 == 0 ? 0 : rf[a2];
	assign rd4 = |a4 == 0 ? 0 : rf[a4];
	assign rd5 = |a5 == 0 ? 0 : rf[a5];
	assign rd7 = |a7 == 0 ? 0 : rf[a7];
	assign rd8 = |a8 == 0 ? 0 : rf[a8];
	assign rd10 = |a10 == 0 ? 0 : rf[a10];
	assign rd11 = |a11 == 0 ? 0 : rf[a11];

	always @(negedge clk) begin
		case ({we3,we6,we9,we12})
			4'b1111:
				if(! ( (a3==a6) | (a3==a9) | (a3==a12) |
					(a6 == a9)  | (a6 == a12) | (a9==a12) ) ) begin
						rf[a3] <= wd3;
						rf[a6] <= wd6;
						rf[a9] <= wd9;
						rf[a12] <= wd12; end
			4'b1011:
				if(!( (a3==a9) | (a3==a12) | (a9==a12) )) begin
						rf[a3] <= wd3;
						rf[a9] <= wd9;
						rf[a12] <= wd12; end
			4'b1101:
				if(!( (a3==a6) | (a3==a12) | (a6==a9) )) begin
						rf[a3] <= wd3;
						rf[a6] <= wd6;
						rf[a9] <= wd9; end
			4'b1110: 
				if(!( (a3==a6) | (a3==a9) | (a6==a9) )) begin
						rf[a3] <= wd3;
						rf[a6] <= wd6;
						rf[a9] <= wd9; end
			4'b0111:
				if(!( (a6==a9) | (a6==a12) | (a9==a12) )) begin
						rf[a6] <= wd6;
						rf[a9] <= wd9; 
						rf[a12] <= wd12; end
			4'b1100: 
				if(!(a3==a6)  ) begin
						rf[a3] <= wd3;
						rf[a6] <= wd6; end
			4'b1010: 
				if(!(a3==a9)  ) begin
						rf[a3] <= wd3;
						rf[a9] <= wd9; end
			4'b1001: 
				if(!(a3==a12)  ) begin
						rf[a3] <= wd3;
						rf[a12] <= wd12; end
			4'b0110: 
				if(!(a6==a9)  ) begin
						rf[a6] <= wd6;
						rf[a9] <= wd9; end
			4'b0101: 
				if(!(a6==a12)  ) begin
						rf[a6] <= wd6;
						rf[a12] <= wd12; end
			4'b0011: 
				if(!(a9==a12)  ) begin
						rf[a9] <= wd9;
						rf[a12] <= wd12; end
			4'b1000:  rf[a3] <= wd3;
			4'b0100:  rf[a6] <= wd6;
			4'b0010:  rf[a9] <= wd9;
			4'b0001:  rf[a12] <= wd12;
	endcase
	end

endmodule
