`define IDLE 3'b001
`define RPLS 3'b010
`define CRDY 3'b100
`define IDLE_BIT 2'b00
`define RPLS_BIT 2'b01
`define CRDY_BIT 2'b10

module cache (
	input [9:0] addr,
	input [31:0] mdata,
	output [31:0] odata,
	output rdy,
	output mem_req,
	input mem_rdy,
	input req,
	input rst_n,
	input clk);

reg [31:0] cmem0[0:31];
reg [31:0] cmem1[0:31];
reg [6:0] tag0[0:3];
reg [6:0] tag1[0:3];
reg lru[0:3];
reg [2:0] stat;
reg [2:0] count;
wire [4:0] caddr;
wire hit0, hit1;
wire hit;

assign hit = hit0 | hit1;

assign caddr = stat[`RPLS_BIT] ? {addr[4:3],count} : addr[4:0];
assign mem_req = req & (stat[`RPLS_BIT] | stat[`IDLE_BIT] & !hit ); 
assign rdy = req & ( (stat[`IDLE_BIT] & hit) | stat[`CRDY_BIT]);

assign hit0 = tag0[addr[4:3]][0] & tag0[addr[4:3]][6:2] == addr[9:5] ;
assign hit1 = tag1[addr[4:3]][0] & tag1[addr[4:3]][6:2] == addr[9:5] ;

assign odata = hit0 ? cmem0[caddr]: 
		hit1 ? cmem1[caddr]: 16'h0000;

always @(posedge clk or negedge rst_n) begin
	if(!rst_n) stat <= `IDLE;
	else 
	case (stat) 
	`IDLE: if(req & !hit ) begin
		stat <= `RPLS;
		count <= 0; 
	       end
	`RPLS: if(mem_rdy) begin
		count <= count+1;
		if(count == 3'b111) 
			stat <= `CRDY;
	       end
	`CRDY: stat <=`IDLE;
	endcase
end
		
always @(posedge clk) 
	if(stat[`RPLS_BIT] & mem_rdy) begin
		 if(lru[addr[4:3]]) cmem0[caddr] <= mdata;
		  else  cmem1[caddr] <= mdata; end

always @(posedge clk) 
	if(stat[`RPLS_BIT] & count == 3'b111) begin
		if(lru[addr[4:3]]) begin
			tag0[addr[5:3]] <= {addr[9:5],2'b01};
			lru[addr[4:3]] <= 1'b0; end
		else begin
			tag1[addr[5:3]] <= {addr[9:5],2'b01};
			lru[addr[4:3]] <= 1'b1; end
         end

endmodule
