/* test bench */
`timescale 1ns/1ps
`include "def.h"
`define CRDY_BIT 2'b10

module test;
parameter STEP = 10;
   reg clk, rst_n;
   wire [`DATA_W-1:0] odata, mdata, wdata ;
   wire [`DATA_W-1:0] daddr, iaddr;
   wire we, req, mem_req, rdy, mem_rdy;
   reg [`DATA_W-1:0] imem [0:`DEPTH-1];
   reg [10:0] count;

   always #(STEP/2) begin
            clk <= ~clk;
   end

   poco poco_1(.clk(clk), .rst_n(rst_n), .idatain(imem[iaddr]),
               .ddatain(odata), .iaddr(iaddr), .daddr(daddr),
               .ddataout(wdata), .we(we), .req(req), .rdy(rdy) );
   cache cache_1(.clk(clk), .rst_n(rst_n), .addr(daddr[9:0]), 
		.mdata(mdata), .odata(odata), .mem_rdy(mem_rdy),
		.rdy(rdy), .mem_req(mem_req), .req(req));
   mmem mmem_1(.clk(clk), .addr(daddr[9:0]),	.datain(wdata),
		.dataout(mdata), .rdy(mem_rdy), .req(mem_req),
		.we(1'b0), .block(1'b1));
	
/*
   always @(posedge clk) 
   begin 
      if(we) dmem[daddr] <= ddataout;
   end
*/

   initial begin
      $dumpfile("poco.vcd");
      $dumpvars(0,test);
      $readmemb("imem.dat", imem);
      $readmemb("tmem.dat", cache_1.tag0);
      $readmemb("tmem.dat", cache_1.tag1);
      $readmemb("lru.dat", cache_1.lru);
      $readmemh("dmem.dat", mmem_1.mem);
      clk <= `DISABLE;
      rst_n <= `ENABLE_N;
	  count <= 0;	
   #(STEP*1/4)
   #STEP
      rst_n <= `DISABLE_N;
   #(STEP*200)            
   $finish;
   end

   always @(negedge clk) begin
   	  count <= count +1;
      $display("count:%d pc:%h idatain:%b ",count, poco_1.pc, poco_1.idatain);
      $display("reg:%h %h %h %h %h %h %h %h", 
	poco_1.rfile_1.r0, poco_1.rfile_1.r1, poco_1.rfile_1.r2,
	poco_1.rfile_1.r3, poco_1.rfile_1.r4, poco_1.rfile_1.r5,
	poco_1.rfile_1.r6, poco_1.rfile_1.r7);
      $display("cmem0_0-7:%h %h %h %h %h %h %h %h", 
	cache_1.cmem0[0], cache_1.cmem0[1], cache_1.cmem0[2], 
	cache_1.cmem0[3], cache_1.cmem0[4], cache_1.cmem0[5], 
	cache_1.cmem0[6], cache_1.cmem0[7]);
      $display("cmem1_0-7:%h %h %h %h %h %h %h %h", 
	cache_1.cmem1[0], cache_1.cmem1[1], cache_1.cmem1[2], 
	cache_1.cmem1[3], cache_1.cmem1[4], cache_1.cmem1[5], 
	cache_1.cmem1[6], cache_1.cmem1[7]);
	if(req) begin
		if(cache_1.hit0) $display("Dmem read %h: cache hit0",daddr);
		else if (cache_1.hit1) $display("Dmem read %h: cache hit1",daddr);
		else $display("Dmem read %h: cache miss",daddr); end
	if (cache_1.stat[`CRDY_BIT]) $display("Cache fill");
   end
endmodule
