`include "mydefinition.h"

module lcdInitializer( clk, rst,
		       pulseCounter,
		       
		       firstSignal, firstPulse,
		       secondSignal, secondPulse,
		       thirdSignal, thirdPulse,
		       fourthSignal, fourthPulse,
		       fifthSignal);

   input clk, rst;
   input [`LCDPULSE] pulseCounter;
      
   output firstSignal, firstPulse;
   output secondSignal, secondPulse;
   output thirdSignal, thirdPulse;
   output fourthSignal, fourthPulse;
   output fifthSignal;

   reg firstSignal, firstPulse;
   reg secondSignal, secondPulse;
   reg thirdSignal, thirdPulse;
   reg fourthSignal, fourthPulse;
   reg fifthSignal;
   
   reg [`LCDINITIALSTATE] lcdInitialStatus;
   reg [`LCDINITIALCOUNTER] lcdInitialCounter;


   always @ ( posedge clk or posedge rst) begin
      if ( rst == `ENABLE) begin
	 lcdInitialStatus <= `LCD_INIT_STATUS_ZERO;
      end else begin
	 if ( ( lcdInitialStatus == `LCD_INIT_STATUS_ZERO &
		lcdInitialCounter == `LCD_INIT_COUNTER_FIRST)| 
	      ( lcdInitialStatus == `LCD_INIT_STATUS_ONE &
		lcdInitialCounter == `LCD_INIT_COUNTER_SECOND)|
	      ( lcdInitialStatus == `LCD_INIT_STATUS_TWO &
		lcdInitialCounter == `LCD_INIT_COUNTER_THIRD)|
	      ( lcdInitialStatus == `LCD_INIT_STATUS_THREE &
		lcdInitialCounter == `LCD_INIT_COUNTER_FOURTH)|
	      ( lcdInitialStatus == `LCD_INIT_STATUS_FOUR &
		lcdInitialCounter == `LCD_INIT_COUNTER_FIFTH)) begin
	    lcdInitialStatus <= lcdInitialStatus + `LCD_INIT_STATUS_ONE;
	 end else begin
	    lcdInitialStatus <= lcdInitialStatus;
	 end
      end
   end
       
   always @ ( posedge clk or posedge rst) begin
      if ( rst == `ENABLE) begin
	 lcdInitialCounter <= `LCD_INIT_COUNTER_ZERO;
      end else begin
	 case ( lcdInitialStatus)
	   `LCD_INIT_STATUS_ZERO:begin
	      if ( lcdInitialCounter < `LCD_INIT_COUNTER_FIRST) begin
		 lcdInitialCounter <= lcdInitialCounter +
				      `LCD_INIT_COUNTER_ONE;
	      end else begin
		 lcdInitialCounter <= `LCD_INIT_COUNTER_ZERO;
	      end
	   end

	   `LCD_INIT_STATUS_ONE: begin
	      if ( (firstSignal & pulseCounter == `LCD_PULSE_MAX) &
		   (~firstPulse & lcdInitialCounter < `LCD_INIT_COUNTER_SECOND)) begin
		 lcdInitialCounter <= lcdInitialCounter +
				      `LCD_INIT_COUNTER_ONE;
	      end else begin
		 lcdInitialCounter <= `LCD_INIT_COUNTER_ZERO;
	      end
	   end

	   `LCD_INIT_STATUS_TWO: begin
	      if ( (firstSignal & pulseCounter == `LCD_PULSE_MAX) &
		   (~firstPulse & lcdInitialCounter < `LCD_INIT_COUNTER_THIRD)) begin
		 lcdInitialCounter <= lcdInitialCounter +
				      `LCD_INIT_COUNTER_ONE;
	      end else begin
		 lcdInitialCounter <= `LCD_INIT_COUNTER_ZERO;
	      end
	   end

	   `LCD_INIT_STATUS_THREE: begin
	      if ( (firstSignal & pulseCounter == `LCD_PULSE_MAX) &
		   (~firstPulse & lcdInitialCounter < `LCD_INIT_COUNTER_FOURTH)) begin
		 lcdInitialCounter <= lcdInitialCounter +
				      `LCD_INIT_COUNTER_ONE;
	      end else begin
		 lcdInitialCounter <= `LCD_INIT_COUNTER_ZERO;
	      end
	   end

	   `LCD_INIT_STATUS_FOUR: begin
	      if ( (firstSignal & pulseCounter == `LCD_PULSE_MAX) &
		   (~firstPulse & lcdInitialCounter < `LCD_INIT_COUNTER_FIFTH)) begin
		 lcdInitialCounter <= lcdInitialCounter +
				      `LCD_INIT_COUNTER_ONE;
	      end else begin
		 lcdInitialCounter <= `LCD_INIT_COUNTER_ZERO;
	      end
	   end

	   default: begin
	      lcdInitialCounter <= lcdInitialCounter;
	   end
	 endcase
      end
   end

		
   //------------------------//
   //       1 to 4 pulse     //
   //------------------------//

   always @ ( posedge clk or posedge rst) begin
      if ( rst == `ENABLE) begin
	 firstPulse <= `LOW;
      end else begin
	 if ( lcdInitialStatus == `LCD_INIT_STATUS_ZERO &
	      lcdInitialCounter == `LCD_INIT_COUNTER_FIRST) begin
	    firstPulse <= `HIGH;
	 end else begin
	    firstPulse <= `LOW;
	 end
      end
   end

   always @ ( posedge clk or posedge rst) begin
      if ( rst == `ENABLE) begin
	 secondPulse <= `LOW;
      end else begin
	 if ( lcdInitialStatus == `LCD_INIT_STATUS_ONE &
	      lcdInitialCounter == `LCD_INIT_COUNTER_SECOND) begin
	    secondPulse <= `HIGH;
	 end else begin
	    secondPulse <= `LOW;
	 end
      end
   end

   always @ ( posedge clk or posedge rst) begin
      if ( rst == `ENABLE) begin
	 thirdPulse <= `LOW;
      end else begin
	 if ( lcdInitialStatus == `LCD_INIT_STATUS_TWO &
	      lcdInitialCounter == `LCD_INIT_COUNTER_THIRD) begin
	    thirdPulse <= `HIGH;
	 end else begin
	    thirdPulse <= `LOW;
	 end
      end
   end

   always @ ( posedge clk or posedge rst) begin
      if ( rst == `ENABLE) begin
	 fourthPulse <= `LOW;
      end else begin
	 if ( lcdInitialStatus == `LCD_INIT_STATUS_THREE &
	      lcdInitialCounter == `LCD_INIT_COUNTER_FOURTH) begin
	    fourthPulse <= `HIGH;
	 end else begin
	    fourthPulse <= `LOW;
	 end
      end
   end

   //-----------------------------//
   // First Signal To Fifth Signal//
   //-----------------------------//
   
   always @ ( posedge clk or posedge rst) begin
      if ( rst == `ENABLE) begin
	 firstSignal <= `LOW;
      end else begin
	 if ( lcdInitialStatus == `LCD_INIT_STATUS_ZERO &
	      lcdInitialCounter == `LCD_INIT_COUNTER_FIRST) begin
	    firstSignal <= `HIGH;
	 end else begin
	    firstSignal <= firstSignal;
	 end
      end
   end // always @ ( posedge clk or posedge rst)

   always @ ( posedge clk or posedge rst) begin
      if ( rst == `ENABLE) begin
	 secondSignal <= `LOW;
      end else begin
	 if ( lcdInitialStatus == `LCD_INIT_STATUS_ONE &
	      lcdInitialCounter == `LCD_INIT_COUNTER_SECOND) begin
	    secondSignal <= `HIGH;
	 end else begin
	    secondSignal <= secondSignal;
	 end
      end
   end // always @ ( posedge clk or posedge rst)

   always @ ( posedge clk or posedge rst) begin
      if ( rst == `ENABLE) begin
	 thirdSignal <= `LOW;
      end else begin
	 if ( lcdInitialStatus == `LCD_INIT_STATUS_TWO &
	      lcdInitialCounter == `LCD_INIT_COUNTER_THIRD) begin
	    thirdSignal <= `HIGH;
	 end else begin
	    thirdSignal <= thirdSignal;
	 end
      end
   end // always @ ( posedge clk or posedge rst)

   always @ ( posedge clk or posedge rst) begin
      if ( rst == `ENABLE) begin
	 fourthSignal <= `LOW;
      end else begin
	 if ( lcdInitialStatus == `LCD_INIT_STATUS_THREE &
	      lcdInitialCounter == `LCD_INIT_COUNTER_FOURTH) begin
	    fourthSignal <= `HIGH;
	 end else begin
	    fourthSignal <= fourthSignal;
	 end
      end
   end // always @ ( posedge clk or posedge rst)

   always @ ( posedge clk or posedge rst) begin
      if ( rst == `ENABLE) begin
	 fifthSignal <= `LOW;
      end else begin
	 if ( lcdInitialStatus == `LCD_INIT_STATUS_FOUR &
	      lcdInitialCounter == `LCD_INIT_COUNTER_FIFTH) begin
	    fifthSignal <= `HIGH;
	 end else begin
	    fifthSignal <= fifthSignal;
	 end
      end
   end
   //=============================================//

      
endmodule // lcdInitializer
