/* test bench */
`timescale 1ns/1ps
`include "def.h"
module poco_top(
input clk50,
input btn_rot, btn_north, btn_south, btn_east, btn_west,
input [3:0] sw,
output reg [7:0] led,
output lcd_rs, lcd_e, lcd_rw,
output [7:0] db);

   wire [`DATA_W-1:0] rd, dmem_rd, wd, instrd ;
   wire [`DATA_W-1:0] daddr, iaddr;
   wire north, east, west, south;
   wire dmem_we, led_we, lcd_we, we;

   wire clk50M0;
   wire clk50M180;
	
   wire rst_n;
   assign dmem_we = ~daddr[15] & we;
   assign led_we = daddr[15] & ~daddr[14] & ~daddr[13] & we;
   assign lcd_we = daddr[15] & ~daddr[14] & daddr[13] & we;
   assign rst_n = ~btn_rot;
   assign rd = daddr[15] & daddr[14] ? {8'b0, north, south, east, west, sw} : 
						dmem_rd;

   always @(negedge clk50M0) 
	if(led_we) led <= wd[7:0];

   pocoDCM PDCM(
		.CLKIN_IN( clk50),
		.RST_IN( btn_rot),
		.CLK0_OUT( clk50M0),
		.CLK180_OUT( clk50M180));
   
   chattering chat0(.clk(clk50M0), .rst_n(rst_n), .in(btn_east), .out(east));
   chattering chat1(.clk(clk50M0), .rst_n(rst_n), .in(btn_west), .out(west));
   chattering chat2(.clk(clk50M0), .rst_n(rst_n), .in(btn_north), .out(north));
   chattering chat3(.clk(clk50M0), .rst_n(rst_n), .in(btn_south), .out(south));

   poco poco_1(.clk(clk50M0), .rst_n(rst_n), .idatain(instrd),
               .ddatain(rd), .iaddr(iaddr), .daddr(daddr),
               .ddataout(wd), .we(we));
   imem imem_1(.clk(clk50M180), .we(1'b0), .addr(iaddr[9:0]), .d(16'b0), .q(instrd));
   dmem dmem_1(.clk(clk50M180), .we(dmem_we), .addr(daddr[9:0]), .d(wd), .q(dmem_rd));

   lcdTop lcdTop0(.clk(clk50M180), .rst(btn_rot),
               .userData(wd[9:0]),
               .userDataEnable(lcd_we),
               .lcdEnable(lcd_e),
               .lcdRegisterSelect(lcd_rs),
               .lcdReadWrite(lcd_rw),
               .dataBitHigh(db[7:4]),
               .dataBitLow(db[3:0]) );

endmodule
