`include "mydefinition.h"

module lcdTop( clk, rst,
	       userData,
	       userDataEnable,
	       lcdEnable,
	       lcdRegisterSelect,
	       lcdReadWrite,
	       dataBitHigh,
	       dataBitLow);

   input clk, rst;
   input [`LCDCOMMAND] userData;
   input 	       userDataEnable;
   
   output lcdEnable;
   output lcdRegisterSelect;
   output lcdReadWrite;
   output [`LCDDATA] dataBitHigh;
   output [`LCDDATA] dataBitLow;

   wire [`LCDCOMMAND] userCommand;
   wire 	      userCommandEnable;

   wire [`LCDCOMMAND] command;
   wire 	      commandEnable;

   wire 	      busy;
   
   lcd LCD( .clk( clk),
	    .rst( rst),
	    .lcdEnable( lcdEnable),
	    .lcdRegisterSelect( lcdRegisterSelect),
	    .lcdReadWrite( lcdReadWrite),
	    .command( command),
	    .commandEnable( commandEnable),
	    .busy( busy),
	    .dataBitHigh( dataBitHigh),
	    .dataBitLow( dataBitLow));

   lcdBuffer LB( .clk( clk),
		 .rst( rst),
		 .command( userCommand),
		 .commandEnable( userCommandEnable),
		 .busy( busy),

		 .bufferOut( command),
		 .bufferEnable( commandEnable));

   lcdUser LU( .clk( clk),
	       .rst( rst),
	       .userData( userData),
	       .userDataEnable( userDataEnable),
	       .command( userCommand),
	       .commandEnable( userCommandEnable));
endmodule // lcdTop
