/* test bench */
`timescale 1ns/1ps
`include "def.h"
module test;
parameter STEP = 10;
   reg clk, rst_n;
   wire [`DATA_W-1:0] ddataout, ddatain ;
   wire [`DATA_W-1:0] iaddr;
   wire [`DATA_W-1:0] daddr;
   wire [`DATA_W-1:0] idata;
   wire we0, we1;
   reg [`DATA_W/2-1:0] dmem0 [0:`DEPTH/2-1];
   reg [`DATA_W/2-1:0] dmem1 [0:`DEPTH/2-1];
   reg [`DATA_W-1:0] imem [0:`DEPTH-1];
   reg [`DATA_W-1:0] imemint [0:`INTMEMDEPTH-1];
   reg [`DATA_W/2-1:0] indata;
   wire [`DATA_W/2-1:0] odata;
   reg set;
  
   wire flag;
   wire dispen, inen, dmemen, re;

   assign dispen = (daddr == 16'h8001);
   assign inen = (daddr == 16'h9001);
   assign dmemen = ~(dispen | inen);
   assign idata = (iaddr[15:8] == 8'hff) ? imemint[iaddr[7:0]] : imem[iaddr];

   always #(STEP/2) begin
            clk <= ~clk;
   end

   poco poco_1(.clk(clk), .rst_n(rst_n), .idatain(idata),
               .ddatain(ddatain), .iaddr(iaddr), .daddr(daddr),
               .ddataout(ddataout), .we1(we1), .we0(we0),
		.intreq(intreq) );
   disp disp_1(.clk(clk), .rst_n(rst_n), .data(ddataout[7:0]),
	.we(we1 & dispen), .flag(flag) );

   inmodule inmodule_1(.clk(clk), .rst_n(rst_n), .idata(indata), .odata(odata),
	.we(set), .re(inen), .flag(intreq));

   always @(posedge clk) 
   begin 
      if(we0 & dmemen) dmem0[daddr[15:1]] <= ddataout[15:8];
   end
   always @(posedge clk) 
   begin 
      if(we1 & dmemen) dmem1[daddr[15:1]] <= ddataout[7:0];
   end

   assign ddatain = dispen ? {15'b0,flag} : inen ? {8'b0, odata} : 
		{dmem0[daddr[15:1]],dmem1[daddr[15:1]]};

   initial begin
      $dumpfile("poco.vcd");
      $dumpvars(0,test);
      $readmemh("dmem0.dat", dmem0);
      $readmemh("dmem1.dat", dmem1);
      $readmemb("imem.dat", imem);
      $readmemb("imemint.dat", imemint);
      clk <= `DISABLE;
      rst_n <= `ENABLE_N;
      indata <= 8'h00;
      set <= `DISABLE;
   #(STEP*1/4)
   #STEP
      rst_n <= `DISABLE_N;
   #(STEP*10)
      indata <= 8'h42;
      set <= `ENABLE;
   #STEP
      set <= `DISABLE;
   #(STEP*30)
   $finish;
   end

   always @(negedge clk) begin
      $display("pc:%h idatain:%b", poco_1.pc, poco_1.idatain);
      $display("reg:%h %h %h %h %h %h %h %h", 
	poco_1.rfile_1.rf[0], poco_1.rfile_1.rf[1], poco_1.rfile_1.rf[2],
	poco_1.rfile_1.rf[3], poco_1.rfile_1.rf[4], poco_1.rfile_1.rf[5],
	poco_1.rfile_1.rf[6], poco_1.rfile_1.rf[7]); 
      $display("intreq:%b int_enable:%b", poco_1.intreq, poco_1.int_enable);
   end 
endmodule
