/* -*- C++ -*-
 *
 * <<< vision_control_unit_test.cc >>>
 *
 * --- control class test program 'vision_control_unit_test'
 *     Copyright (C) 1995-2001 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#include <iostream>
#include "control_unit.h"

//#define TU_DEBUG
//#define T_DEBUG

template<class D>
void left_right_connect_function(D& a, D& b)
{
	b.right_data_input().connect(a.right_data_output());
	b.right_status_input().connect(a.right_status_output());
	b.right_input_send().connect(a.right_output_send());
	b.right_output_receive().connect(a.right_input_receive());

	b.left_data_output().connect(a.left_data_input());
	b.left_status_output().connect(a.left_status_input());
	b.left_output_send().connect(a.left_input_send());
	b.left_input_receive().connect(a.left_output_receive());
};

int main(void)
{
	
	vision_control_unit<int> a, b;
	int temp = 0, temp2 = 0;

	/* connect port */
	left_right_connect_function(a,b);
	/*
	b.left_data_input().connect(a.right_data_output());
	b.left_status_input().connect(a.right_status_output());
	b.left_input_send().connect(a.right_output_send());
	b.left_output_send().connect(a.right_input_send());
	b.left_output_receive().connect(a.right_input_receive());
	b.left_input_receive().connect(a.right_output_receive());
	*/

	/* RIGHT SEND DATA */

	a.address_buffer() = 0x3004;
	a.data_buffer() = 3;
	b.address_buffer() = 0x3000;
	b.data_buffer() = 13;

	a.clock_in();
	b.clock_in();
	b.clock_out();
	a.clock_out();

	cout << "After 1clock" << endl;

	/* RIGHT SEND STATUS */
	a.address_buffer() = 0x3006;
	a.data_buffer() = 5;
	b.address_buffer() = 0x3002;
	b.data_buffer() = 15;

	a.clock_in();
	b.clock_in();
	b.clock_out();
	a.clock_out();

	cout << "After 2clock" << endl;

	a.data_buffer() = 0;
	b.data_buffer() = 0;

//	a.clock_in();
//	b.clock_in();
//	b.clock_out();
//	a.clock_out();

	a.clock_in();
	b.clock_in();
	b.clock_out();
	a.clock_out();

	cout << "After 3clock" << endl;
	//cout << b.left_r_d_reg() << " " << b.left_r_s_reg() << endl;
	
	
	/* LEFT RECEIVE DATA */
	a.address_buffer() = 13;
	b.address_buffer() = 12;

	a.clock_in();
	b.clock_in();
	b.clock_out();
	a.clock_out();

	temp = a.data_buffer();
	temp2 = b.data_buffer();

	cout << "After 4clock" << endl;
//	cout << b.left_r_d_reg() << " " << b.left_r_s_reg() << endl;
	cout << "a : " << temp << "  b : " << temp2 << endl;


	/* LEFT RECEIVE STATUS */
	a.address_buffer() = 17;
	b.address_buffer() = 16;

	a.clock_in();
	b.clock_in();
	b.clock_out();
	a.clock_out();

	temp = a.data_buffer();
	temp2 = b.data_buffer();

	cout << "After 5clock" << endl;
	//cout << b.left_r_d_reg() << " " << b.left_r_s_reg() << endl;
	cout << "a : " << temp << "  b : " << temp2 << endl;

	//cout << "DATA : " << temp << " STATUS : " << temp2 << endl;

	a.address_buffer() = 18;
	b.address_buffer() = 18;

	a.clock_in();
	b.clock_in();
	b.clock_out();
	a.clock_out();

	temp = a.data_buffer();
	temp2 = b.data_buffer();


	//cout << "Status Buffer : " << temp2 << endl;
	cout << "After 6clock" << endl;
	cout << "a : " << temp << "  b : " << temp2 << endl;
	//cout << b.left_r_d_reg() << " " << b.left_r_s_reg() << endl;

	a.clock_in();
	b.clock_in();
	b.clock_out();
	a.clock_out();
	a.clock_in();
	b.clock_in();
	b.clock_out();
	a.clock_out();

	return 0;

}


