/* -*- C++ -*-
 *
 * <<< pico.h >>>
 *
 * --- pico class 'pico'
 *     Copyright (C) 1995-2001 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#ifndef PICO_H
#define PICO_H 1

#include <string>
#include <isis/port.h>
#include <isis/memory_control_unit.h>
#include "pico_typedef.h"
#include "pico_base.h"
#include "pico_bus_interface.h"
#include "pico_integer_unit.h"
#include "pico_timer_unit.h"
#include "control_unit.h"
#include "receive_reg.h"


class pico_bus_interface;
class pico_integer_unit;
class pico_timer_unit;

class pico : public pico_base
{
private:
	typedef pico thisclass;
	typedef pico_base inherited;
	typedef pico_word word;
public:
	typedef inherited::address_type address_type;
	typedef inherited::data_type data_type;
	static const size_t sizeof_data_type = inherited::sizeof_data_type;
	
	const word pico_local_memory_address;
	const word pico_local_memory_size;

	mapped_memory<word>* local_memory;
	vision_control_unit<word>* cont_unit0;
	vision_control_unit<word>* cont_unit1;
private:
	pico_integer_unit* int_unit;
	pico_bus_interface* bus_if;
	pico_timer_unit* ti_unit;
	bool halt_flag_;
	size_t freq_mag_;
public:
	pico(void);
	pico(const thisclass&);
	virtual ~pico();
	virtual void output(std::ostream&) const;
	virtual bool output(std::ostream&, const std::string&) const;
	virtual data_type register_file(size_t) const;
	virtual data_type& register_file(size_t);
	virtual address_type program_counter(void) const;
	virtual address_type print_program_counter(void) const;
	virtual address_type& program_counter(void);
	virtual address_type& print_program_counter(void);
	virtual address_type print_memory_address(void);
	virtual address_type print_memory_access(void);
	virtual bool is_halt(void) const;
	virtual bool is_stall(void) const;
	virtual bool is_reading(void) const;
	virtual bool is_writing(void) const;
	virtual bool is_user_mode(void) const;
	virtual bool is_kernel_mode(void) const;
	virtual void clock_in(void);
	virtual void clock_out(void);
	virtual void reset(void);
	virtual void halt(void);
	virtual size_t frequency_magnification(void) const;
	virtual void set_frequency_magnification(size_t);
	virtual const port& port_ref(void) const;
	virtual port& port_ref(void);
	void enable_streaming(void);
	void disable_streaming(void);
	/* set timer value */
	void set_timer_address(address_type);
	void set_timer_count(data_type); 
	data_type hi(void) const;
	data_type lo(void) const;

	// for debug
	virtual const receive_reg_& receive_data0(void) const {
		return int_unit -> receive_data0(); }
	virtual const receive_reg_& receive_data1(void) const {
		return int_unit -> receive_data1(); }
    std::string opcode_string(int stage) const {
		return int_unit -> opcode_string(stage); }

};

#endif /* PICO_H */
