/* -*- C++ -*-
 *
 * <<< pico_bus_interface.h >>>
 *
 * --- pico bus interface class 'pico_bus_interface'
 *     Copyright (C) 1995-2001 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#ifndef PICO_BUS_INTERFACE_H
#define PICO_BUS_INTERFACE_H 1

#include <isis/bus_port.h>
#include "pico_typedef.h"

class pico_bus_interface : public bus_port<pico_word, pico_word>
{
private:
	typedef pico_bus_interface thisclass;
	typedef bus_port<pico_word, pico_word> inherited;
public:
	typedef inherited::address_type address_type;
	typedef inherited::data_type data_type;
	typedef inherited::transaction_id_type transaction_id_type;
	pico_bus_interface(void);
	pico_bus_interface(const pico_bus_interface&);
	virtual ~pico_bus_interface();
};

#endif /* PICO_BUS_INTERFACE_H */
