/* -*- C++ -*-
 *
 * <<< pico_instruction_buffer.h >>>
 *
 * --- pico instruction buffer class 'pico_instruction_buffer'
 *     Copyright (C) 1995-2001 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#ifndef PICO_INSTRUCTION_BUFFER_H
#define PICO_INSTRUCTION_BUFFER_H 1

#include <isis/instruction_buffer.h>
#include "pico_pipeline_stage.h"


class pico_instruction_buffer : public instruction_buffer
		< pico_pipeline_stage, c_array<pico_pipeline_stage, 5> >
{
private:
	typedef pico_instruction_buffer thisclass;
	typedef instruction_buffer
		< pico_pipeline_stage, c_array<pico_pipeline_stage, 5> > inherited;
public:
	typedef inherited::container_type container_type;
	typedef inherited::value_type value_type;
	typedef inherited::size_type size_type;
	typedef inherited::reference reference;
	typedef inherited::const_reference const_reference;
	pico_instruction_buffer(void);
	pico_instruction_buffer(const thisclass&);
	virtual ~pico_instruction_buffer();
    virtual void output(std::ostream&) const;
	const_reference if_stage(void) const { return (*this)[0]; }
	const_reference rf_stage(void) const { return (*this)[1]; }
	const_reference ex_stage(void) const { return (*this)[2]; }
	const_reference wb_stage(void) const { return (*this)[3]; }
	reference if_stage(void) { return (*this)[0]; }
	reference rf_stage(void) { return (*this)[1]; }
	reference ex_stage(void) { return (*this)[2]; }
	reference wb_stage(void) { return (*this)[3]; }
};

#endif /* PICO_INSTRUCTION_BUFFER_H */
