/* -*- C++ -*-
 *
 * <<< pico_integer_unit.h >>>
 *
 * --- pico integer unit class 'pico_integer_unit'
 *     Copyright (C) 1995-2001 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#ifndef PICO_INTEGER_UNIT_H
#define PICO_INTEGER_UNIT_H 1

#include <string>
#include "pico_typedef.h"
#include "pico_instruction_buffer.h"
#include "pico_multiply_unit.h"
#include "pico_register_file.h"
#include <isis/memory_control_unit.h>
#include "control_unit.h"
#include "pico_memory_map.h"
#include "pico_timer_unit.h"


class pico_integer_unit
{
public:
	typedef pico_word address_type;
	typedef pico_word data_type;
	typedef pico_word word;
	typedef signed_pico_word signed_data_type;
	typedef unsigned_pico_word unsigned_data_type;
	static const size_t sizeof_data_type = sizeof_pico_word;
private:
	typedef pico_integer_unit thisclass;
	pico_instruction_buffer inst_buf;
	pico_register_file gpr;
	pico_multiply_unit mul_unit;
	mapped_memory<word>& local_memory;
	vision_control_unit<word>& cont_unit0;
	vision_control_unit<word>& cont_unit1;
	pico_timer_unit& ti_unit;
	address_type pc_;
	address_type print_pc_;
	address_type memory_address_;
	address_type memory_access_mode_;
	// execute in run cycle, streaming
	void instruction_fetch(void);
	void register_fetch(void);
	void execute(void);
	void memory_access(void);
	void writeback(void);
	// execute in stall cycle
	bool mult_delay, mult_delay2, delay_slot2_, delay_slot3_;
	bool delay_slot_, rtn_delay_slot_, rtn_delay_slot2_;
	bool mult_delay3;

public:
	pico_integer_unit(mapped_memory<word>&, vision_control_unit<word>&,
						vision_control_unit<word>&, pico_timer_unit&);
	pico_integer_unit(const thisclass&,
		mapped_memory<word>&, vision_control_unit<word>&, vision_control_unit<word>&, pico_timer_unit&);
	virtual ~pico_integer_unit();
	pico_integer_unit& operator=(const pico_integer_unit&);
	data_type register_file(size_t i) const { return gpr[i]; }
	data_type hi(void) const { return mul_unit.hi(); }
	data_type lo(void) const { return mul_unit.lo(); }
	address_type pc(void) const { return pc_; }
	data_type& register_file(size_t i) { return gpr[i]; }
	data_type& hi(void) { return mul_unit.hi(); }
	data_type& lo(void) { return mul_unit.lo(); }
	address_type& pc(void) { return pc_; }
	bool& delay_slot(void) { return delay_slot_; }
	void clock(void);
	void reset(void);
	void output(std::ostream&) const;
	bool output(std::ostream&, const std::string& s) const;

	// for debug 
	address_type print_pc(void) const { return print_pc_; }
	address_type& print_pc(void) { return print_pc_; }
	address_type& memory_address(void) { return memory_address_; }
	address_type& memory_access_mode(void) { return memory_access_mode_; }
	receive_reg_& receive_data0(void) const{
		return cont_unit0.receive_data();
	}
	receive_reg_& receive_data1(void) const{
		return cont_unit1.receive_data();
	}

	std::string opcode_string(int stage) const;
	
};

std::ostream& operator<<(std::ostream&, const pico_integer_unit&);

#endif /* PICO_INTEGER_UNIT_H */
