/* -*- C++ -*-
 *
 * <<< pico_multiply_unit.h >>>
 *
 * --- pico multiply/divide unit class 'pico_multiply_unit'
 *     Copyright (C) 1995-2001 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

 #include <iostream>

#ifndef PICO_MULTIPLY_UNIT_H
#define PICO_MULTIPLY_UNIT_H 1

#include "pico_typedef.h"

class pico_multiply_unit
{
public:
	typedef pico_word data_type;
	typedef signed_pico_word signed_data_type;
	typedef unsigned_pico_word unsigned_data_type;
	static const size_t sizeof_data_type = sizeof_pico_word;
private:
	typedef pico_multiply_unit thisclass;
	static const unsigned int default_mult_wait, default_div_wait;
	data_type hi_, lo_;
	unsigned int mult_wait_, div_wait_, count;
public:
	pico_multiply_unit(void);
	pico_multiply_unit(const thisclass&);
	bool ready(void) const { return count == 0; }
	bool busy(void) const { return count > 0; }
	data_type hi(void) const { return hi_; }
	data_type lo(void) const { return lo_; }
	data_type& hi(void) { return hi_; }
	data_type& lo(void) { return lo_; }
	inline void mult(data_type, data_type);
	inline void multi(data_type, data_type);
	inline void multu(data_type, data_type);
	inline void mulfi(data_type, data_type);
	inline void mulff(data_type, data_type);
	inline void div(data_type, data_type);
	inline void divu(data_type, data_type);
	void clock(void) { if (busy()) count--; }
	void clear(void);
	unsigned int mult_wait(void) const { return mult_wait_; }
	unsigned int div_wait(void) const { return div_wait_; }
	void set_mult_wait(unsigned int);
	void set_div_wait(unsigned int);
};

inline void pico_multiply_unit::multu
	(pico_multiply_unit::data_type a, pico_multiply_unit::data_type b)
{
	data_type a_hi = (a >> 8), a_lo = a & 0x00ffU,
			  b_hi = (b >> 8), b_lo = b & 0x00ffU;
	data_type tmp1 = a_lo * b_lo;
	data_type tmp2 = (a_hi * b_lo + a_lo * b_hi + (tmp1 >> 8));
	lo_ = (tmp2 << 8) | (tmp1 & 0x00ffUL);
	hi_ = a_hi * b_hi + (tmp2 >> 8);
	count = mult_wait();
}

inline void pico_multiply_unit::mult
	(pico_multiply_unit::data_type a, pico_multiply_unit::data_type b)
{
	data_type a_ = ((a & 0x8000UL) == 0) ? a : (~a + 1),
			  b_ = ((b & 0x8000UL) == 0) ? b : (~b + 1);
	lo_ = (a_ * b_) & 0xffffUL;
	if ((a ^ b) & 0x8000UL) {
		lo_ = ~lo_ + 1;
	}
}

inline void pico_multiply_unit::multi
	(pico_multiply_unit::data_type a, pico_multiply_unit::data_type b)
{
	data_type a_ = ((a & 0x8000UL) == 0) ? a : (~a + 1),
			  b_ = ((b & 0x8000UL) == 0) ? b : (~b + 1);
	lo_ = (a_ * b_) & 0xffffUL;
	if ((a ^ b) & 0x8000UL) {
		lo_ = ~lo_ + 1;
	}
  /*
	multu(a_, b_);
	if ((a ^ b) & 0x8000UL) {
		if (lo_ != 0) {
			lo_ = ~lo_ + 1;
			hi_ = ~hi_ + 1;
		} else {
			hi_ = ~hi_ + 1;
		}
	}
	*/
}

inline void pico_multiply_unit::mulfi
	(pico_multiply_unit::data_type a, pico_multiply_unit::data_type b)
{
	data_type a_ = ((a & 0x8000UL) == 0) ? a : (~a + 1);
	data_type b_ = ((b & 0x8000UL) == 0) ? b : (~b + 1);

	//a_ is fixed point

	lo_ = ((a_ * b_) >> 8) & 0xffffUL;
	if ((a ^ b) & 0x8000UL) {
		lo_ = ~lo_ + 1;
	}

/*
	data_type a_hi = (a >> 8), a_lo = (a & 0x00ff),
	          b_hi = (b_ >> 8), b_lo = (b_ & 0x00ff);

	data_type tmp1 = a_lo * b_lo;
	data_type tmp2 = (a_hi * b_lo + ((a_lo * b_hi) >> 8));
	lo_ = tmp1 + ((a_lo * b_hi) & 0xff);
	hi_ = a_hi * b_hi + tmp2;
	*/
	
}

inline void pico_multiply_unit::mulff
	(pico_multiply_unit::data_type a, pico_multiply_unit::data_type b)
{
	data_type a_ = ((a & 0x8000UL) == 0) ? a : (~a + 1),
			  b_ = ((b & 0x8000UL) == 0) ? b : (~b + 1);

	lo_ = ((a_ * b_) >> 8) & 0xffffUL;

	if ((a ^ b) & 0x8000UL) {
		lo_ = ~lo_ + 1;
	}
/*
	data_type a_hi = ((a_ & 0xff00) >> 8), a_lo = (a_ & 0x00ff),
	          b_hi = ((b_ & 0xff00) >> 8), b_lo = (b_ & 0x00ff);
	data_type tmp1 = a_lo * b_lo;
	data_type tmp2 = (a_hi * b_lo + a_lo * b_hi);
	lo_ = (tmp1 >> 8) + (tmp2 & 0x00ff);
	hi_ = a_hi * b_hi + (tmp2 >> 8);
	*/

}
/*
inline void pico_multiply_unit::div
	(pico_multiply_unit::data_type a, pico_multiply_unit::data_type b)
{
	signed_data_type a_ = signed_data_type(a), b_ = signed_data_type(b);
	lo_ = data_type(a_ / b_);
	hi_ = data_type(a_ % b_);
	count = div_wait();
}

inline void pico_multiply_unit::divu
	(pico_multiply_unit::data_type a, pico_multiply_unit::data_type b)
{
	lo_ = a / b;
	hi_ = a % b;
	count = div_wait();
}
*/

#endif /* PICO_MULTIPLY_UNIT_H */
