/*
 * <<< pico_processing_element.cc >>>
 *
 * --- pico processing element class 'pico_processing_element'
 *     Copyright (C) 1997-2001 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#include <iostream>
#include "pico_processing_element.h"

//#define DEBUG
//#define DUMP
using namespace std;

static int loader(ifstream&);
static unsigned int string_hex_to_unsigned_int(const string& a);

const pico_processing_element::address_type
	pico_processing_element::default_multi_io_area_address = 0x4000;
const pico_processing_element::size_type
	pico_processing_element::default_multi_io_area_size = 0x2000;



pico_processing_element::pico_processing_element(void)
{
  set_multi_io_area(default_multi_io_area_address,
					default_multi_io_area_size);
}


pico_processing_element::pico_processing_element
	(const pico_processing_element& a)
	: inherited(a)
{
}

pico_processing_element::~pico_processing_element()
{

}

void pico_processing_element::clock_in(void)
{
	pu.clock_in();

}

void pico_processing_element::clock_out(void)
{
	pu.clock_out();
}

void pico_processing_element::output(std::ostream& os) const
{
	os << pu;
#ifdef DEBUG
	os.flush();
#endif // DEBUG
}

bool pico_processing_element::output(std::ostream& os, 
									 const string& s) const
{
	if (s == "pu") {
		os << pu;
		return true;
		}
	return pu.output(os, s);
}

bool pico_processing_element::load(const char* a, int& halt_adr)
{
	{
	    // gcc ver3.0.2 didn't accept "ios::nocreate"
	    // 		ifstream file(a, ios::in | ios::nocreate ); 
	    //		if (file.bad()) return 1;
	    ifstream file(a, ios::in ); 
		if (!file) return 1;

#ifdef MEMORY_DUMP
		ofstream MEMORY_DUMP("MEMORY_DUMP", 
								  ios::out | 
								  ios::trunc);
#endif //MEMORY_DUMP


	int i, j;
	typedef pico_word word_type;
	const int buf_size = 128;
	const int WRITE_SIZE = 128;
	const size_t sizeof_word_type = 2;
	int buf[buf_size];
	word_type adr = 00000000;
	int read_flag = 1;

	while(read_flag){
	for(i = 0; (i / sizeof_word_type ) < buf_size ;
									i += sizeof_word_type){
		buf[i / sizeof_word_type] = loader(file);

		if(buf[i / sizeof_word_type] == 0x10000){
			// file is end;
			read_flag = -1;
			break;
		}
#ifdef DEBUG
		cout << "Read " << buf[i] << endl;
#endif // DEBUG

	}

	for(j = 0; j <= i; j += sizeof_word_type){
		pu.local_memory -> write(adr + j, buf[j / sizeof_word_type]);

		if(buf[j / sizeof_word_type] == 2048){
			// instruction is halt
			halt_adr = adr + j + 4;
		//	cout << "Set End of Program! " << hex <<  adr + j <<  endl;
		}
	}

		adr += (j - sizeof_word_type);

		read_flag++;
	}// while(1)


#ifdef DEBUG
	word_type dat;
	for(j = 0; j <= i; j += sizeof_word_type){
		dat = pu.local_memory -> read(adr + j);
		cout << setw(8) << adr + i << " " << setw(8) << dat << endl;
	}
#endif // DEBUG
#ifdef MEMORY_DUMP
		pu.local_memory.dump(MEMORY_DUMP);
#endif// MEMORY_DUMP
		pu.program_counter() = 0;
	}

	bool flag = true;
	return flag;
}

void pico_processing_element::disassemble
	(std::ostream& os,
	 pico_processing_element::address_type top,
	 pico_processing_element::size_type size) const
{
}


static int loader(ifstream& file)
{
	while (1) {
		char c;

		if (!file){
			break;
		}

		if (!(file >> c)){
			return (0x10000);
		}

		if (c == '@') {
			unsigned int adr, c0, c1;
			string adr_str, c0_str, c1_str, tmp;
			file >> adr_str >> c0_str >> c1_str;
			adr = string_hex_to_unsigned_int(adr_str);
			c0 = string_hex_to_unsigned_int(c0_str);

			// check
#ifdef DEBUG
			cout << "adr:" << adr
			 << " (" << c0 << ',' << c1 << ')' << endl;
#endif //DEBUG

			return c0;
		}
		while (1) {
			if (!file || !file.get(c)) break;
			if (c == '\n') break;
		}
	}

	return 0;
}

unsigned int string_hex_to_unsigned_int(const string& a)
{
	unsigned int value = 0;
	for (size_t i = 0; i < a.size(); i++) {
		const char c = a[i];
		int t;
		switch (c) {
		case '0': t =  0; break;
		case '1': t =  1; break;
		case '2': t =  2; break;
		case '3': t =  3; break;
		case '4': t =  4; break;
		case '5': t =  5; break;
		case '6': t =  6; break;
		case '7': t =  7; break;
		case '8': t =  8; break;
		case '9': t =  9; break;
		case 'a': t = 10; break;
		case 'A': t = 10; break;
		case 'b': t = 11; break;
		case 'B': t = 11; break;
		case 'c': t = 12; break;
		case 'C': t = 12; break;
		case 'd': t = 13; break;
		case 'D': t = 13; break;
		case 'e': t = 14; break;
		case 'E': t = 14; break;
		case 'f': t = 15; break;
		case 'F': t = 15; break;
		default:  t =  0; break;
		}
		value = (value << 4) + t;
	}
	return value;
}
