/*
 * <<< pico_processing_element_test.cc >>>
 *
 * --- Test program for pico_processing_element
 *     Copyright (C) 2000-2001 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#include <cstdlib>
#include <iostream>
#include <isis/cui_debugger.h>
#include <isis/halt_detector.h>
#include "pico_processing_element.h"
#include <isis/bus_port.h>
#include <isis/isis.h>
#include "pico_typedef.h"
#include "pico.h"

#define REG_DUMP
#define MEM_DUMP
#define MEM_DUMP2

int main(int, char** argv)
{
	typedef pico_processing_element processing_element_type;
	typedef processing_element_type::size_type size_type;
	typedef pico_word word;
	const pico_word local_memory_address = 0;
	const pico_word local_memory_size = 0x3200;
//	const pico_word local_memory_size = 0x20000000;
//	size_type icache_size = 0x2000, dcache_size = 0x2000;
	unsigned int wait_time = 0, verbose_level = 0;

#ifdef REG_DUMP
	ofstream reg_dump("reg_dump", ios::out | ios::trunc);
	ofstream sp_dump("sp_dump", ios::out | ios::trunc);
	ofstream tb_dump("tb_dump", ios::out | ios::trunc);
	ofstream bb_dump("bb_dump", ios::out | ios::trunc);
#endif //REG_DUMP

#ifdef MEM_DUMP
		ofstream mem_dump("mem_dump", ios::out | ios::trunc);
#endif //MEM_DUMP

	halt_detector<word> mon;
	bus_port<word> bus_if;

	mon.port_ref().connect(bus_if);


	/*
	bool icache_flag = false, dcache_flag = false, fpa_flag = false,
		 split_flag = false, clock_flag = false, trace_flag = false,
		monitor_flag = false;
		*/
	bool fpa_flag = false,
		 split_flag = false, clock_flag = false, trace_flag = false,
		monitor_flag = false;
	ifstream file;

	// read commandline argument for simulator
	while (*++argv != NULL && **argv == '-') {
		while (*++*argv != '\0') {
			bool flag = 0;
			switch (**argv) {
			case 'c': clock_flag = true; break;
			case 'f': fpa_flag = true; break;
			case 'm': monitor_flag = true; break;
			case 's': split_flag = true; break;
			case 't': trace_flag = clock_flag = true; break;
			case 'v': verbose_level++; clock_flag = true; break;
			case 'w': wait_time = atoi(*argv + 1); flag = true; break;
			default: break;
			}
			if (flag) break;
		}
	}
	if (*argv == NULL) {
		cerr << "No executable file specified." << endl;
		return 1;
	}

	// setup simulation conditions
	processing_element_type pe;
//	pe.set_local_memory_area(local_memory_address, local_memory_size);

	int halt_adr = 0x0024;

	if (!pe.load(*argv, halt_adr)) {
		cerr << *argv << ": No such file or directory." << endl;
		return 1;
	}
	mon.set_address(halt_adr);
//	cout << "Halt Address : " << halt_adr << endl;

#ifdef MEM_DUMP
		pe.processor().local_memory -> dump(mem_dump);
#endif// MEM_DUMP

	if (split_flag) pe.enable_split_transaction();
	if (wait_time > 0) {
		pe.set_local_memory_read_wait(wait_time);
		pe.set_local_memory_write_wait(wait_time);
	}
	pe.set_file_table_size(16);
	pe.set_standard_input_stream(cin);
	pe.set_standard_output_stream(cout);
	pe.set_standard_error_stream(cerr);
	pe.set_commandline_argument((const char* const*)(argv));

	//pe.processor().set_timer_address(0x31fe);
	//pe.processor().set_timer_count(0x1);

	// show simulation conditions
	if (verbose_level >= 1) {
		cout << "processor:   pico" << endl;
		cout << "coprocessor: " << (fpa_flag ? "yes" : "no") << endl;
		cout << "memory:      0x" << hex << setw(8) << setfill('0')
			 << local_memory_address << " - 0x" << setw(8) << setfill('0')
			 << local_memory_address + local_memory_size - 1 << dec << endl;
		cout << "memory wait: " << wait_time << "clk" << endl;
		cout << "split-trans: " << (split_flag ? "yes" : "no") << endl;
		cout << "arguments:   \"";
		for (int i = 0; argv[i] != NULL; i++) {
			if (i != 0) cout << ' ';
			cout << argv[i];
		}
		cout << '"' << endl << endl;
	}

		int cl = 0;
	if (!monitor_flag) {
		// execute simulation in non-interactive mode
		while (1) {
			if (verbose_level >= 2) {
				cout << "clk:" << pe.timer_clock_value() << endl
					 << pe.processor() << endl << endl;
			} else if (trace_flag) {
				cout << "0x" << hex << pe.processor().program_counter()
					 << dec << endl;
			}
			if (pe.is_halt()){
				cout << "Processor is halt! " << endl;
				break;
			}
//			cout << " hoge " << endl;
			if (pe.is_bus_error()) {
				cout << hex
					 << "bus error(I:0x" << pe.processor().program_counter()
					 << ", D:0x" << pe.bus_error_address() << ')'
					 << dec << endl;
				break;
			}
			bus_if.send_single_write_request(pe.processor().program_counter());
			pe.clock_in();
			mon.clock_in();
			mon.clock_out();
			pe.clock_out();
#ifdef REG_DUMP
		const int REG_SIZE = 8;
		const int SP_REG = 9;
		const int TB_REG = 17;
		const int BB_REG = 25;
		int i;

//		reg_dump << setw(8) << cl << ": ";
		reg_dump << setw(8) << hex << pe.processor().program_counter() << ": ";
		cl++;
		for(i = 0; i < REG_SIZE; i++){
			reg_dump << setw(5) << pe.processor().register_file(i) << " ";
		}
		reg_dump << endl;

		sp_dump << setw(8) << cl << ": ";
		for(i = 0; i < REG_SIZE; i++){
			sp_dump << setw(5) << pe.processor().register_file(i + SP_REG) << " ";
		}
		sp_dump << endl;

		tb_dump << setw(8) << cl << ": ";
		for(i = 0; i < REG_SIZE; i++){
			tb_dump << setw(5) << pe.processor().register_file(i + TB_REG) << " ";
		}
		tb_dump << endl;

		bb_dump << setw(8) << cl << ": ";
		for(i = 0; i < REG_SIZE; i++){
			bb_dump << setw(5) << pe.processor().register_file(i + BB_REG) << " ";
		}
		bb_dump << endl;

		//cout << pu.int_unit.gpr.rf << endl;
#endif //REG_DUMP
		if(mon.is_halt()){
#ifdef MEM_DUMP2
		ofstream mem_dump2("mem_dump2", ios::out | ios::trunc);
		pe.processor().local_memory -> dump(mem_dump2);
#endif// MEM_DUMP2
			break;
		}

		}
		if (clock_flag) cout << "clock: " << pe.timer_clock_value() << endl;
		return pe.commandline_status();
	} else {
		// execute simulation in interactive mode
		cui_debugger<processing_element_type> mon;
		mon.set(pe);
		mon.interactive_mode();
		return 0;
	}
	// not reached
}


