/*
 * <<< pico_register_file.cc >>>
 *
 * --- pico register file class 'pico_register_file'
 *     Copyright (C) 1995-1999 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#include <cctype>
#include <cstring> // needed only for SGI C++ compiler
#include <iomanip>
#include <iostream>
#include "pico_register_file.h"
#include "pico_memory_map.h"

using namespace std;

string pico_register_file::register_name(int i)
{
	string value;

	if(i <= 7){
		value = 'r';
		value += char('0' + i);
	}
	else if(i == 8){
		value = "pc";
	}
	else if(i <= 16){
		value = "sp";
		value += char('0' + (i - 9));

	}
	else if(i <= 24){
		value = "tb";
		value += char('0' + (i - 17));

	}
	else if(i <= 32){
		value = "bb";
		value += char('0' + (i - 25));
	}
	else if(i <= 33){
		value == "flag register";
	}
	else if(i <= 34){
		value == "prefix register";
	}
	else if(i <= 35){
		value == "System Stack Register";
	}
	else{
		value = "error";
	}

	return value;
}

int pico_register_file::register_number(const string &a)
{
	int i;

	if(a[0] == 'r' || a[0] == 'R'){
		if(a.length() == 2 && isdigit(a[1])){
			return int(a[1] - '0');
		}
	}
	else if(a[0] == 's' || a[0] == 'S'){
		if(a.length() == 3 && isdigit(a[2])){
			return int(a[2] - '0');
		}
	}
	else if(a[0] == 't' || a[0] == 'T'){
		if(a.length() == 3 && isdigit(a[2])){
			return int(a[2] - '0');
		}
	}
	else if(a[0] == 'b' || a[0] == 'B'){
		if(a.length() == 3 && isdigit(a[2])){
			return int(a[2] - '0');
		}
	}
	else if(a[0] == 'p' && a[1] == 'c'){
		return 8;
	}
	else if(a[0] == 'z' && a[1] == 'f'){
		return 0;
	}
	else if(a[0] == 'n' && a[1] == 'f'){
		return 0;
	}

	return -1; /* error */
}

pico_register_file::pico_register_file(void)
{

	/* set Sp register */
	(*this)[9] = 0x2b00;
	(*this)[10] = 0x2c00;
	(*this)[11] = 0x2d00;
	(*this)[12] = 0x2e00;
	(*this)[13] = 0x2f00;
	(*this)[14] = 0x3000;
	(*this)[15] = 0x3100;
	(*this)[16] = 0x3200;

	/* set Tb register */
	(*this)[17] = 0x2a00;
	(*this)[18] = 0x2b00;
	(*this)[19] = 0x2c00;
	(*this)[20] = 0x2d00;
	(*this)[21] = 0x2e00;
	(*this)[22] = 0x2f00;
	(*this)[23] = 0x3000;
	(*this)[24] = 0x3100;

	/* set bb register */
	(*this)[25] = 0x2b00;
	(*this)[26] = 0x2c00;
	(*this)[27] = 0x2d00;
	(*this)[28] = 0x2e00;
	(*this)[29] = 0x2f00;
	(*this)[30] = 0x3000;
	(*this)[31] = 0x3100;
	(*this)[32] = 0x3200;

	(*this)[33] = 0;
	(*this)[34] = 0;
	(*this)[35] = System_Stack_Initial_Address;
		
}

pico_register_file::pico_register_file(const pico_register_file& a)
	: inherited(a)
{

}

pico_register_file::~pico_register_file()
{
}

void pico_register_file::output(ostream& os) const
{
	char char_table[] = { '0', '1', '2', '3', '4', '5', '6', '7', '8',
		'9' };
	const char fill = os.fill();
	std::ostream::fmtflags flags = os.flags();
	os << hex << setfill('0');
	for(size_t i = 0; i < size(); i++){
		os << 'r' << char_table[i / 10] << char_table[i % 10]
		   << '(' << register_name(i)
		   << "):" << setw(8) << (*this)[i];

		if((i & 3) == 0){
			os << '\n';
		}
		else{
			os << ' ';
		}
	}
	os.fill(fill);
	os.flags(flags);

#ifdef DEBUG
	os.flush();
#endif // DEBUG
}

