/* -*- C++ -*-
 *
 * <<< pico_register_file.h >>>
 *
 * --- pico register file class 'pico_register_file'
 *     Copyright (C) 1995-2001 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#ifndef PICO_REGISTER_FILE_H
#define PICO_REGISTER_FILE_H 1

#include <string>
#include <isis/c_array.h>
#include "pico_typedef.h"
#include <isis/register_file.h>


const int REG_NUM = 37;

class pico_register_file
	: public register_file< pico_word, c_array<pico_word, REG_NUM> >
{
private:
	typedef pico_register_file thisclass;
	typedef register_file< pico_word, c_array<pico_word, REG_NUM> > inherited;
public:
	typedef inherited::container_type container_type;
	typedef inherited::value_type value_type;
	typedef inherited::size_type size_type;
	static std::string register_name(int);
	static int register_number(const std::string&);
	pico_register_file(void);
	pico_register_file(const thisclass&);
	virtual ~pico_register_file();
	virtual void output(std::ostream&) const;
	value_type r0(void) const { return (*this)[0]; }
	value_type r1(void) const { return (*this)[1]; }
	value_type r2(void) const { return (*this)[2]; }
	value_type r3(void) const { return (*this)[3]; }
	value_type r4(void) const { return (*this)[4]; }
	value_type r5(void) const { return (*this)[5]; }
	value_type r6(void) const { return (*this)[6]; }
	value_type r7(void) const { return (*this)[7]; }
	value_type pc(void) const { return (*this)[8]; }

	value_type sp0(void) const { return (*this)[9]; }
	value_type sp1(void) const { return (*this)[10]; }
	value_type sp2(void) const { return (*this)[11]; }
	value_type sp3(void) const { return (*this)[12]; }
	value_type sp4(void) const { return (*this)[13]; }
	value_type sp5(void) const { return (*this)[14]; }
	value_type sp6(void) const { return (*this)[15]; }
	value_type sp7(void) const { return (*this)[16]; }

	value_type tb0(void) const { return (*this)[17]; }
	value_type tb1(void) const { return (*this)[18]; }
	value_type tb2(void) const { return (*this)[19]; }
	value_type tb3(void) const { return (*this)[20]; }
	value_type tb4(void) const { return (*this)[21]; }
	value_type tb5(void) const { return (*this)[22]; }
	value_type tb6(void) const { return (*this)[23]; }
	value_type tb7(void) const { return (*this)[24]; }

	value_type bb0(void) const { return (*this)[25]; }
	value_type bb1(void) const { return (*this)[26]; }
	value_type bb2(void) const { return (*this)[27]; }
	value_type bb3(void) const { return (*this)[28]; }
	value_type bb4(void) const { return (*this)[29]; }
	value_type bb5(void) const { return (*this)[30]; }
	value_type bb6(void) const { return (*this)[31]; }
	value_type bb7(void) const { return (*this)[32]; }

	value_type zf(void) const { return (*this)[33]; }
	value_type pf(void) const { return (*this)[34]; }
	value_type ssp(void) const { return (*this)[35]; }

	value_type& r0(void) { return (*this)[0]; }
	value_type& r1(void) { return (*this)[1]; }
	value_type& r2(void) { return (*this)[2]; }
	value_type& r3(void) { return (*this)[3]; }
	value_type& r4(void) { return (*this)[4]; }
	value_type& r5(void) { return (*this)[5]; }
	value_type& r6(void) { return (*this)[6]; }
	value_type& r7(void) { return (*this)[7]; }
	value_type& pc(void) { return (*this)[8]; }

	value_type& sp0(void) { return (*this)[9]; }
	value_type& sp1(void) { return (*this)[10]; }
	value_type& sp2(void) { return (*this)[11]; }
	value_type& sp3(void) { return (*this)[12]; }
	value_type& sp4(void) { return (*this)[13]; }
	value_type& sp5(void) { return (*this)[14]; }
	value_type& sp6(void) { return (*this)[15]; }
	value_type& sp7(void) { return (*this)[16]; }

	value_type& tb0(void) { return (*this)[17]; }
	value_type& tb1(void) { return (*this)[18]; }
	value_type& tb2(void) { return (*this)[19]; }
	value_type& tb3(void) { return (*this)[20]; }
	value_type& tb4(void) { return (*this)[21]; }
	value_type& tb5(void) { return (*this)[22]; }
	value_type& tb6(void) { return (*this)[23]; }
	value_type& tb7(void) { return (*this)[24]; }

	value_type& bb0(void) { return (*this)[25]; }
	value_type& bb1(void) { return (*this)[26]; }
	value_type& bb2(void) { return (*this)[27]; }
	value_type& bb3(void) { return (*this)[28]; }
	value_type& bb4(void) { return (*this)[29]; }
	value_type& bb5(void) { return (*this)[30]; }
	value_type& bb6(void) { return (*this)[31]; }
	value_type& bb7(void) { return (*this)[32]; }

	value_type& zf(void) { return (*this)[33]; }
	value_type& pf(void) { return (*this)[34]; }
	value_type& ssp(void) { return (*this)[35]; }

};

#endif /* PICO_REGISTER_FILE_H */
