

#ifndef PICO_TIMER_UNIT_H
#define PICO_TIMER_UNIT_H

#include <iostream>
#include "pico_typedef.h"
#include <isis/mapped_memory.h>

class pico_timer_unit
{
private:
	typedef pico_timer_unit thisclass;

public:
	typedef pico_word data_type;
	typedef pico_word address_type;
	typedef pico_word word;

private:
	data_type counter_;
	data_type memory_counter_;
	address_type memory_address_;
	data_type clock_count_;

	address_type operation_memory_address_;
	address_type counter_set_address_;
	data_type operation_;
	mapped_memory<word>& local_memory;

public:
	pico_timer_unit(mapped_memory<word>&);
	pico_timer_unit(mapped_memory<word>&, address_type, data_type = 0xffff);
	address_type& timer_memory_address(void) { return memory_address_; }
	data_type& timer_clock_count(void) { return clock_count_; }
	data_type read_count(void) const { return counter_; }
	data_type& set_operation(void) { return operation_; }

	void clock_in(void);
	void reset(void);
	void output(std::ostream&) const;

};

#endif // PICO_TIMER_UNIT_H
