/* -*- C++ -*-
 *
 * <<< result_unit.cc >>>
 *
 * --- result unit class 'result unit'
 *     Copyright (C) 1995-2001 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */


#include "result_unit.h"

//#define DEBUG 1

void vision_result_output_unit::clock_in(void)
{

	switch(state){
	case WAIT:
	#ifdef DEBUG
		cout << "WAIT" << endl;
	#endif
		// processor write result to buffer
		
		if(result_decode1_ == true || counter_ == (BUFFER_SIZE - 1)){
			result_status_ = 1;
			update_enable_ = false;
			count_enable_ = true;
			result_decode1_ = false;
			state = LOAD;
		}
		break;
	case LOAD:
	{
	#ifdef DEBUG
		cout << "LOAD";
	#endif
		
		output_counter_ = counter_ + 1;

		int k = 0;
		while(counter_ >= 0){
			output_result_[k] = input_result_[counter_];
			#ifdef DEBUG
				cout << output_result_[k] << " ";
			#endif
			counter_--;
			k++;
		}

		#ifdef DEBUG
			cout << endl;
		#endif

		if(output_counter_ <= 1){
			update_enable_ = true;
			result_reset_ = false;
			state = SHIFT_END;
		}
		else{
			count_enable_ = false;
			state = SHIFT;
		}
	}
		break;
	case SHIFT:
	#ifdef DEBUG
		cout << "SHIFT" << endl;
	#endif
		if(output_counter_ <= 1){
			result_reset_ = false;
			update_enable_ = true;
			count_enable_ = true;
			state = SHIFT_END;

		}
		break;
	case SHIFT_END:
	#ifdef DEBUG
		cout << "SHIFT_END" << endl;
	#endif
		result_reset_ = true;
		state = WAIT;

		break;
	default:
		break;
	}

	if(result_decode0_ == true && count_enable_ == true){
		input_result_[counter_] = data_buffer_;
		counter_++;
		result_decode0_ = false;
	}
}

void vision_result_output_unit::clock_out(void)
{


	// Create Packet
	if(output_counter_ > 0){
		output_counter_--;

		Result_pkt = new vision_packet<D>;
		((vision_packet<D>*)Result_pkt ) -> data() = 
				output_result_[output_counter_];

	#ifdef DEBUG
		cout << "Send Packet " << output_result_[output_counter_] 
		<< endl;
	#endif

		if(output_counter_ == 0){
			result_status_ = 0;
		}

	// Send Packet

		Result_Output.put(Result_pkt);
	}

}

void vision_result_output_unit::reset(void)
{
	result_status_ = 0;
	counter_ = 0;
	output_counter_ = 0;
	count_enable_ = true;
	result_reset_ = true;
	update_enable_ = true;
	state = WAIT;

}


vision_result_output_unit::vision_result_output_unit(void)
	:result_status_(0),
	 counter_(0),
	 output_counter_(0),
	 count_enable_(true),
	 result_reset_(true),
	 update_enable_(true),
	 result_decode0_(false),
	 result_decode1_(false),
	 state(WAIT)
{

}


vision_result_output_unit::vision_result_output_unit(thisclass& a)
	:result_status_(0),
	 counter_(0),
	 output_counter_(0),
	 count_enable_(true),
	 result_reset_(true),
	 update_enable_(true),
	 result_decode0_(false),
	 result_decode1_(false),
	 state(WAIT)
{

}

vision_result_output_unit::~vision_result_output_unit()
{

}
