/* -*- C++ -*-
 *
 * <<< result_unit.h >>>
 *
 * --- result unit class 'result unit'
 *     Copyright (C) 1995-2001 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#ifndef VISION_RESULT_OUTPUT_UNIT_H
#define VISION_RESULT_OUTPUT_UNIT_H 1

#include <iostream>
#include <isis/synchronous_unit.h>
#include "pico_typedef.h"
#include "vision_port.h"
#include "vision_packet.h"


class vision_result_output_unit : public synchronous_unit
{
private:
	typedef vision_result_output_unit thisclass;
	typedef pico_word data_type;
	typedef pico_word address_type;
	typedef pico_word D;
	static const int BUFFER_SIZE = 16;

	enum result_state{
		WAIT,
		LOAD,
		SHIFT,
		SHIFT_END,
	};
	result_state state;

	int result_status_;
	bool count_enable_, update_enable_, result_reset_;
	bool result_decode0_, result_decode1_;
	int counter_, output_counter_;
	data_type input_result_[BUFFER_SIZE];
	data_type output_result_[BUFFER_SIZE];
	data_type data_buffer_;

	/* Port */
	vision_port Result_Output;

	/* Packet */
	packet *Result_pkt;


public:
	vision_result_output_unit(void);
	vision_result_output_unit(thisclass&);
	~vision_result_output_unit();

	/* Port Connection */
	vision_port& Data_Output_Port(){ return Result_Output; }

	int& result_status(void) { return result_status_; }
	data_type& data_buffer(void) { return data_buffer_; }
	bool &decode0(void) { return result_decode0_; }
	bool &decode1(void) { return result_decode1_; }
	void reset(void);
	void clock_in(void);
	void clock_out(void);


};

#endif // VISION_RESULT_OUTPUT_UNIT_H
