/* This doesn't look like -*- C++ -*-, but it is! */

/* pisa.def - SimpleScalar portable ISA (pisa) machine definition */

/* SimpleScalar(TM) Tool Suite
 * Copyright (C) 1994-2003 by Todd M. Austin, Ph.D. and SimpleScalar, LLC.
 * All Rights Reserved. 
 * 
 * THIS IS A LEGAL DOCUMENT, BY USING SIMPLESCALAR,
 * YOU ARE AGREEING TO THESE TERMS AND CONDITIONS.
 * 
 * No portion of this work may be used by any commercial entity, or for any
 * commercial purpose, without the prior, written permission of SimpleScalar,
 * LLC (info@simplescalar.com). Nonprofit and noncommercial use is permitted
 * as described below.
 * 
 * 1. SimpleScalar is provided AS IS, with no warranty of any kind, express
 * or implied. The user of the program accepts full responsibility for the
 * application of the program and the use of any results.
 * 
 * 2. Nonprofit and noncommercial use is encouraged. SimpleScalar may be
 * downloaded, compiled, executed, copied, and modified solely for nonprofit,
 * educational, noncommercial research, and noncommercial scholarship
 * purposes provided that this notice in its entirety accompanies all copies.
 * Copies of the modified software can be delivered to persons who use it
 * solely for nonprofit, educational, noncommercial research, and
 * noncommercial scholarship purposes provided that this notice in its
 * entirety accompanies all copies.
 * 
 * 3. ALL COMMERCIAL USE, AND ALL USE BY FOR PROFIT ENTITIES, IS EXPRESSLY
 * PROHIBITED WITHOUT A LICENSE FROM SIMPLESCALAR, LLC (info@simplescalar.com).
 * 
 * 4. No nonprofit user may place any restrictions on the use of this software,
 * including as modified by the user, by any other authorized user.
 * 
 * 5. Noncommercial and nonprofit users may distribute copies of SimpleScalar
 * in compiled or executable form as set forth in Section 2, provided that
 * either: (A) it is accompanied by the corresponding machine-readable source
 * code, or (B) it is accompanied by a written offer, with no time limit, to
 * give anyone a machine-readable copy of the corresponding source code in
 * return for reimbursement of the cost of distribution. This written offer
 * must permit verbatim duplication by anyone, or (C) it is distributed by
 * someone who received only the executable form, and is accompanied by a
 * copy of the written offer of source code.
 * 
 * 6. SimpleScalar was developed by Todd M. Austin, Ph.D. The tool suite is
 * currently maintained by SimpleScalar LLC (info@simplescalar.com). US Mail:
 * 2395 Timbercrest Court, Ann Arbor, MI 48105.
 * 
 * Copyright (C) 1994-2003 by Todd M. Austin, Ph.D. and SimpleScalar, LLC.
 */


/* This file defines all aspects of the SimpleScalar instruction set
 * architecture.  Each instruction set in the architecture has a DEFINST()
 * macro call included below.  The contents of a instruction definition are
 * as follows:
 *
 *   DEFINST(<enum>,			<opcode>,
 *	     <opname>,			<operands>,
 *	     <fu_req>,			<iflags>,
 *	     <output deps...>,		<input deps...>,
 *	     <expr>)
 *
 * Where:
 *
 *   <enum>	- is an enumerator that is returned when an instruction is
 *		  decoded by SS_OP_ENUM()
 *   <opcode>	- is the opcode of this instruction
 *   <opname>   - name of this instruction as a string, used by disassembler
 *   <operands>	- specified the instruction operand fields and their printed
 * 		  order for disassembly, used by disassembler, the recognized
 *		  operand field are (the instruction format is detailed in
 *		  the header file ss.h):
 *		    J - target field
 *		    j - PC relative target (offset + PC)
 *		    s - S register field
 *		    b - S register field (base register)
 *		    t - T register field
 *		    d - D register field
 *		    S - S register field (FP register)
 *		    T - T register field (FP register)
 *		    D - D register field (FP register)
 *		    o - load address offset (offset)
 *		    i - signed immediate field value
 *		    u - unsigned immediate field value
 *		    U - upper immediate field value
 *		    H - shift amount immediate field value
 *		    B - break code
 *
 *   <fu_req>	- functional unit requirements for this instruction
 *   <iflags>	- instruction flags, accessible via the SS_OP_FLAGS()
 *		  macro, flags are defined with F_* prefix in ss.h
 *   <output deps...>
 *		- a list of up to two output dependency designators, the
 *		  following designators are recognized (place an DNA in any
 *		  unused fields:
 *		    DGPR(N)   - general purpose register N
 *		    DGPR_D(N) - double word general purpose register N
 *		    DCGPR(N)  - general purpose register conditional on
 *			        pre/post- increment/decrement mode
 *		    DFPR_L(N) - floating-point register N, as word
 *		    DFPR_F(N) - floating-point reg N, as single-prec float
 *		    DFPR_D(N) - floating-point reg N, as double-prec double
 *		    DHI	      - HI result register
 *		    DLO	      - LO result register
 *		    DFCC      - floating point condition codes
 *		    DCPC      - current PC
 *		    DNPC      - next PC
 *		    DNA	      - no dependence
 *
 *   <input deps...>
 *		- a list of up to three input dependency designators, the
 *		  designators are defined above (place an DNA in any unused
 *		  fields.
 *
 *   <expr>	- a C expression that implements the instruction being
 * 		  defined, the expression must modify all architected state
 *		  affected by the instruction's execution, by default, the
 *		  next PC (NPC) value defaults to the current PC (CPC) plus
 *		  SS_INST_SIZE, as a result, only taken branches need to set
 *		  NPC
 *
 *		  The following predefined macros are available for use in
 *		  DEFINST() instruction expressions to access the value of
 *		  instruction operand/opcode field values:
 *
 *		    RS	    - RS register field value
 *		    RT	    - RT register field value
 *		    RD	    - RD register field value
 *		    FS	    - RS register field value
 *		    FT	    - RT register field value
 *		    FD	    - RD register field value
 *		    BS	    - RS register field value
 *		    TARG    - jump target field value
 *		    OFS	    - signed offset field value
 *		    IMM	    - signed offset field value
 *		    UIMM    - unsigned offset field value
 *		    SHAMT   - shift amount field value
 *		    BCODE   - break code field value
 *
 *		  To facilitate the construction of performance simulators
 *		  (which may want to specialize their architected state
 *		  storage format), all architected register and memory state
 *		  is accessed through the following macros:
 *
 *		    GPR(N)         - read general purpose register N
 *		    SET_GPR(N,E)   - write general purpose register N with E
 *		    GPR_D(N)       - read double word general purpose reg N
 *		    SET_GPR_D(N,E) - write double word gen purpose reg N w/ E
 *		    FPR_L(N)       - read floating-point register N, as word
 *		    SET_FPR_L(N,E) - floating-point reg N, as word, with E
 *		    FPR_F(N)       - read FP reg N, as single-prec float
 *		    SET_FPR_F(N,E) - write FP reg N, as single-prec float w/ E
 *		    FPR_D(N)       - read FP reg N, as double-prec double
 *		    SET_FPR_D(N,E) - write FP reg N, as double-prec double w/E
 *		    HI	           - read HI result register
 *		    SET_HI(E)      - write HI result register with E
 *		    LO	           - read LO result register
 *		    SET_LO(E)      - write LO result register with E
 *		    FCC	           - read floating point condition codes
 *		    SET_FCC(E)     - write floating point condition codes w/ E
 *		    CPC	           - read current PC register
 *		    NPC	           - read next PC register
 *		    SET_NPC(E)     - write next PC register with E
 *		    TPC	           - read target PC register
 *		    SET_TPC(E)     - write target PC register with E
 *
 *		    READ_SIGNED_BYTE(A)   - read signed byte from address A
 *		    READ_UNSIGNED_BYTE(A) - read unsigned byte from address A
 *		    READ_SIGNED_HALF(A)   - read signed half from address A
 *		    READ_UNSIGNED_HALF(A) - read unsigned half from address A
 *		    READ_WORD(A)          - read word from address A
 *		    WRITE_BYTE(E,A)       - write byte value E to address A
 *		    WRITE_HALF(E,A)       - write half value E to address A
 *		    WRITE_WORD(E,A)       - write word value E to address A
 *
 *		  Finally, the following helper functions are available to
 *		  assist in the construction of instruction expressions:
 *
 *		    INC_DEC(E,N,S) - execute E and update N as per pre/post-
 *				     incr/decr addressing sementics for an
 *				     access of S bytes
 *		    OVER(X,Y)      - check for overflow for X+Y, both signed
 *		    UNDER(X,Y)	   - check for umderflow for X-Y, both signed
 *		    DIV0(N)	   - check for divide by zero, N is denom
 *		    INTALIGN(N)    - check double word int reg N alignment
 *		    FPALIGN(N)	   - check double word FP reg N alignment
 *		    TALIGN(T)	   - check jump target T alignment
 */


/*
$B%l%8%9%?$N99?7$d%W%m%;%C%530It$X$NMW5aH/9T$J$I!"(B
$BJ#?t$NL?Na$G9T$o$l$k=hM}$r%a%s%P4X?t$H$7$FDj5A$7!"(B
$B3FL?Na$,8F$S=P$;$k$h$&$K$7$F$"$k!#(B
*/

#include "isim_processor.h"
//#define OBSL_DEBUG_ISIM_PROCESSOR

/*
 * configure the execution engine
 */
void
isim_processor::set_tpc(md_addr_t expr)
{
  target_PC = expr;
}

void
isim_processor::set_npc(md_addr_t expr)
{
  regs.regs_NPC = expr;
}

/* current program counter */
md_addr_t
isim_processor::cpc(void)
{
  return regs.regs_PC;
}

void
isim_processor::set_cpc(md_addr_t expr)
{
  regs.regs_PC = expr;
}

/* general purpose register accessors */
signed int
isim_processor::gpr(int n)
{
  return regs.regs_R[n];
}

void
isim_processor::set_gpr(int n, signed int expr)
{
  regs.regs_R[n] = expr;
}

/* floating point register accessors */
signed int
isim_processor::fpr_l(int n)
{
  return regs.regs_F.l[n];
}

void
isim_processor::set_fpr_l(int n, signed int expr)
{
  regs.regs_F.l[n] = expr;
}

float
isim_processor::fpr_f(int n)
{
  return regs.regs_F.f[n];
}

void
isim_processor::set_fpr_f(int n, float expr)
{
  regs.regs_F.f[n] = expr;
}

double
isim_processor::fpr_d(int n)
{
  return regs.regs_F.d[n>>1];
}

void
isim_processor::set_fpr_d(int n, double expr)
{
  regs.regs_F.d[n>>1] = expr;
}

/* miscellanous register accessors */
signed int
isim_processor::hi(void)
{
  return regs.regs_C.hi;
}

void
isim_processor::set_hi(signed int expr)
{
  regs.regs_C.hi = expr;
}

signed int
isim_processor::lo(void)
{
  return regs.regs_C.lo;
}

void
isim_processor::set_lo(signed int expr)
{
  regs.regs_C.lo = expr;
}

int
isim_processor::fcc(void)
{
  return regs.regs_C.fcc;
}

void
isim_processor::set_fcc(int expr)
{
  regs.regs_C.fcc = expr;
}

/* precise architected memory state accessor macros */
byte_t
isim_processor::read_byte(md_addr_t src, md_fault_type fault0)
{
  addr = src;
  fault0 = mem_simple.mem_access(mem, Read, addr, 
								 &temp_byte, sizeof(temp_byte), 0);
  return temp_byte;
}

half_t
isim_processor::read_half(md_addr_t src, md_fault_type fault0)
{
  addr = src;
  fault0 = mem_simple.mem_access(mem, Read, addr, 
								 &temp_half, sizeof(temp_half), 0);
  return temp_half;
}

word_t
isim_processor::read_word(md_addr_t src, md_fault_type fault0)
{
  addr = src;
  
  if ( addr == PU_ID_ADDRESS )
	return puid;
  else if ( addr == PU_NUM_ADDRESS ) {
	return punum;
  } else {
	fault0 = mem_simple.mem_access(mem, Read, addr, 
								   &temp_word, sizeof(temp_word), 0);
	return temp_word;
  }
}

void
isim_processor::write_byte(md_addr_t src, md_addr_t dst, md_fault_type fault0)
{
  temp_byte = src;
  addr = dst;
  fault0 = mem_simple.mem_access(mem, Write, addr,
								 &temp_byte, sizeof(temp_byte), 0);
}

void
isim_processor::write_half(md_addr_t src, md_addr_t dst, md_fault_type fault0)
{
  temp_half = src;
  addr = dst;
  fault0 = mem_simple.mem_access(mem, Write, addr,
								 &temp_half, sizeof(temp_half), 0);
}

void
isim_processor::write_word(md_addr_t src, md_addr_t dst, md_fault_type fault0)
{
  temp_word = src;
  addr = dst;
  fault0 = mem_simple.mem_access(mem, Write, addr,
								 &temp_word, sizeof(temp_word), 0);
}

/* system call handler macro */
void
isim_processor::syscall(md_inst_t inst0)
{
  load_simple.sys_syscall(&regs, mem, inst0, TRUE, puid, sim_num_insn);
}

/* fetch an instruction */
void
isim_processor::md_fetch_inst(md_addr_t pc)
{
  inst.a = mem_simple.mem_read_word(mem, pc);
  inst.b = mem_simple.mem_read_word(mem, pc + sizeof(word_t));
}

void
isim_processor::declare_fault(md_fault_type fault0)
{
  fault = fault0;
}

unsigned int
isim_processor::extractl(int word, int pos, int num)
{
  return(((unsigned int) word >> (pos + 1 - num)) & ~(~0 << num));
}

//$B%*%Z%i%s%I$N(BData$B$r!"%l%8%9%?$b$7$/$O(Breorder buffer$B$+$i3NJ](B
void
isim_processor::choose_operand(bool in_flag, sword_t* operand,
							   int rgs, int num)
{
  if (!in_flag)
	*operand = gpr(rgs);
  else {
	if ( s1_flag[num] ) {
	  *operand = s1[num];
	} else if ( s2_flag[num] ) {
	  *operand = s2[num];
	}
  }
#ifdef OBSL_DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  cout.fill('0');
  cout << "0x" << hex << setw(8) << *operand << " ";
  cout.flags(flags);
#endif
}

//$B%*%Z%i%s%I$N(BData$B$r!"%l%8%9%?$b$7$/$O(Breorder buffer$B$+$i3NJ](B
void
isim_processor::choose_operand_hi(bool in_flag, sword_t* operand, int num)
{
  if (!in_flag)
	*operand = hi();
  else {
	if ( s1_flag[num] ) {
	  *operand = s1[num];
	} else if ( s2_flag[num] ) {
	  *operand = s2[num];
	}
  }
#ifdef OBSL_DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  cout.fill('0');
  cout << "0x" << hex << setw(8) << *operand << " ";
  cout.flags(flags);
#endif
}

//$B%*%Z%i%s%I$N(BData$B$r!"%l%8%9%?$b$7$/$O(Breorder buffer$B$+$i3NJ](B
void
isim_processor::choose_operand_lo(bool in_flag, sword_t* operand, int num)
{
  if (!in_flag)
	*operand = lo();
  else {
	if ( s1_flag[num] ) {
	  *operand = s1[num];
	} else if ( s2_flag[num] ) {
	  *operand = s2[num];
	}
  }
#ifdef OBSL_DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  cout.fill('0');
  cout << "0x" << hex << setw(8) << *operand << " ";
  cout.flags(flags);
#endif
}

//$B%*%Z%i%s%I$N(BData$B$r!"%l%8%9%?$b$7$/$O(Breorder buffer$B$+$i3NJ](B
void
isim_processor::choose_operand_l(bool in_flag, sword_t* operand,
								 int rgs, int num, bool* stop_flag)
{
  if (!in_flag)
	*operand = fpr_l(rgs);
  else {
	if ( s1_flag[num] )
	  *operand = s1[num];
	else if ( s2_flag[num] )
	  *operand = s2[num];
	else
	  *stop_flag = true;
  }
#ifdef OBSL_DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  if(!stop_flag){
	cout.fill('0');
	cout << "0x" << hex << setw(8) << *operand << " ";
	cout.flags(flags);
  } else {
	cout << "---------- ";
  }
#endif
}

//$B%*%Z%i%s%I$N(BData$B$r!"%l%8%9%?$b$7$/$O(Breorder buffer$B$+$i3NJ](B
void
isim_processor::choose_operand_fcc(bool in_flag, int* operand,
								   int num, bool* stop_flag)
{
  if (!in_flag)
	*operand = fcc();
  else {
	if ( s_i_flag[num] )
	  *operand = s_i[num];
	else
	  *stop_flag = true;
  }
#ifdef OBSL_DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  if(!stop_flag){
	cout.fill('0');
	cout << "0x" << hex << setw(8) << *operand << " ";
	cout.flags(flags);
  } else {
	cout << "---------- ";
  }
#endif
}

//$B%*%Z%i%s%I$N(BData$B$r!"%l%8%9%?$b$7$/$O(Breorder buffer$B$+$i3NJ](B
void
isim_processor::choose_operand_ff(bool in_flag, sfloat_t* operand,
								 int rgs, int num, bool* stop_flag)
{
  if (!in_flag)
	*operand = fpr_f(rgs);
  else {
	if ( s_ff_flag[num] )
	  *operand = s_ff[num];
	else
	  *stop_flag = true;
  }
#ifdef OBSL_DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  if(!stop_flag){
	cout.fill('0');
	cout << "0x" << hex << setw(8) << *operand << " ";
	cout.flags(flags);
  } else {
	cout << "---------- ";
  }
#endif
}

//$B%*%Z%i%s%I$N(BData$B$r!"%l%8%9%?$b$7$/$O(Breorder buffer$B$+$i3NJ](B
void
isim_processor::choose_operand_fd(bool in_flag, dfloat_t* operand,
								 int rgs, int num, bool* stop_flag)
{
  if (!in_flag)
	*operand = fpr_d(rgs);
  else {
	if ( s_fd_flag[num] )
	  *operand = s_fd[num];
	else
	  *stop_flag = true;
  }
#ifdef OBSL_DEBUG_ISIM_PROCESSOR
  ios_base::fmtflags flags = cout.flags();
  if(!stop_flag){
	cout.fill('0');
	cout << "0x" << hex << setw(8) << *operand << " ";
	cout.flags(flags);
  } else {
	cout << "---------- ";
  }
#endif
}
