#include "instqueue.h"

instqueue::instqueue()
{
  ListHead = ListTail = NULL;  
  ruu_num = 0;
  lsq_num = 0;
}

//$BL?Na$NEjF~(B
void
instqueue::insert(md_inst_t inst, INST_SEQ_TYPE seq, bool adr_flag,
				  md_addr_t branch_PC, md_addr_t now_PC, md_addr_t next_PC,
				  md_addr_t pred_PC, bpred_update_t *dir,
				  int in1, int in2,  int in3, int in4,
				  int out1, int out2, int out3,
				  bool ls_flag, bool mem_flag, INST_SEQ_TYPE branch_seq)
{
  if ( !adr_flag && mem_flag )
	lsq_num++;
  else if ( !adr_flag && !mem_flag )
	ruu_num++;


  struct INSTList *temp;
  if ( ListTail == NULL ) {
    ListHead = ListTail = (struct INSTList*)malloc(sizeof(struct INSTList));
    if ( ListHead == NULL ) {
	  perror("malloc");
	  exit(1);
	}
	ListHead->inst = inst;
	ListHead->seq = seq;
	//ListHead->set = true;
	ListHead->adr_flag = adr_flag;
	ListHead->prev_branch_PC = branch_PC;
	ListHead->now_PC = now_PC;
	ListHead->next_PC = next_PC;
	ListHead->pred_PC = pred_PC;
	ListHead->dir = dir;
	ListHead->in1 = in1;
	ListHead->in2 = in2;
	ListHead->in3 = in3;
	ListHead->in4 = in4;
	ListHead->out1 = out1;
	ListHead->out2 = out2;
	ListHead->out3 = out3;
	ListHead->l_or_s = ls_flag;
	ListHead->exec_ok = true;
	ListHead->try_issue_time = 0;
	ListHead->mem_flag = mem_flag;
	ListHead->branch_seq = branch_seq;
	if ( branch_seq == 0 )
	  ListHead->branch_result = 1;
	else
	  ListHead->branch_result = 0;
	ListHead->exec_time = -1;
	ListHead->adr = 0;
	ListHead->adr2 = 0;
	ListHead->adr_area = 0;
	ListHead->load_finish = false;
	ListHead->load_data = 0;
	ListHead->load_data2 = 0;
	ListHead->load_data_half = 0;
	ListHead->load_data_byte = 0;
	ListHead->load_flag = false;
	ListHead->lsq_data_flag = false;
	ListHead->use_lsq_flag = false;
    ListHead->next = NULL;
  } else {
	temp = (struct INSTList*)malloc(sizeof(struct INSTList));
    if ( temp == NULL ) {
	  perror("malloc");
	  exit(1);
	}
	temp->inst = inst;
	temp->seq = seq;
	//temp->set = true;
	temp->adr_flag = adr_flag;
	temp->prev_branch_PC = branch_PC;
	temp->now_PC = now_PC;
	temp->next_PC = next_PC;
	temp->pred_PC = pred_PC;
	temp->dir = dir;
	temp->in1 = in1;
	temp->in2 = in2;
	temp->in3 = in3;
	temp->in4 = in4;
	temp->out1 = out1;
	temp->out2 = out2;
	temp->out3 = out3;
	temp->l_or_s = ls_flag;
	temp->exec_ok = true;
	temp->try_issue_time = 0;
	temp->mem_flag = mem_flag;
	temp->branch_seq = branch_seq; 
	if ( branch_seq == 0 )
	  temp->branch_result = 1;      
	else
	  temp->branch_result = 0;
	temp->exec_time = -1;
	temp->adr = 0;
	temp->adr2 = 0;
	temp->adr_area = 0;
	temp->load_finish = false;
	temp->load_data = 0;
	temp->load_data2 = 0;
	temp->load_data_half = 0;
	temp->load_data_byte = 0;
	temp->load_flag = false;
	temp->lsq_data_flag = false;
	temp->use_lsq_flag = false;
	temp->next = NULL;
	ListTail->next = temp;
	ListTail = temp;
  }
}

//issue$B2D$JL?Na$rJV$9(B
instqueue::INSTList_type*
instqueue::return_reservation_station_inst(int time0)
{
  struct INSTList *Listptr;
  Listptr = ListHead;
  
  while( Listptr != NULL ) {
	if ( Listptr->try_issue_time < time0 && Listptr->exec_ok) {
	  Listptr->try_issue_time = time0;
	  return Listptr;
	}
	Listptr = Listptr->next;
  }
  return NULL;
}

//$BL?Na$rJV$9(B
instqueue::INSTList_type*
instqueue::return_inst(INST_SEQ_TYPE inst_id)
{
  struct INSTList *Listptr;
  Listptr = ListHead;
  
  while( Listptr != NULL ) {
	if ( Listptr->seq == inst_id ) {
	  return Listptr;
	}
	Listptr = Listptr->next;
  }
  return NULL;
}

//$BL?Na$NGK4~(B
void
instqueue::deletelist(INST_SEQ_TYPE seq)
{
  struct INSTList *Listptr;
  struct INSTList *temp;
  Listptr = ListHead;

  if ( Listptr == NULL )
	return;

  while (1) {
	if ( Listptr == ListHead && Listptr->seq == seq ) {
	  ListHead = Listptr->next;
	  if ( ListTail  == Listptr )
		ListTail = NULL;
	  if ( !Listptr->adr_flag && Listptr->mem_flag )
		lsq_num--;
	  else if ( !Listptr->adr_flag && !Listptr->mem_flag )
		ruu_num--;
	  free(Listptr);
	  return;
	}
	if ( Listptr->next != NULL && Listptr->next->seq == seq ) {
	  if ( ListTail == Listptr->next )
		ListTail = Listptr;
	  temp = Listptr->next;
	  Listptr->next = temp->next;
	  if ( !temp->adr_flag && temp->mem_flag )
		lsq_num--;
	  else if ( !temp->adr_flag && !temp->mem_flag )
		ruu_num--;
	  free(temp);
	  return;
	}
	if ( Listptr->next == NULL )
	  return;
	Listptr = Listptr->next;
  }
  assert(0);
}

//$BL?Na$rJV$9(B
instqueue::INSTList_type*
instqueue::return_after_this(INST_SEQ_TYPE inst_id)
{
  struct INSTList *Listptr;
  Listptr = ListHead;
  
  while( Listptr != NULL ) {
	if ( Listptr->seq > inst_id ) {
	  return Listptr;
	}
	Listptr = Listptr->next;
  }
  return NULL;
}

void
instqueue::printlist()
{
  struct INSTList *Listptr;
  Listptr = ListHead;
  if ( ListHead == NULL ) {
	printf("No List\n");
  }
  while (Listptr != NULL){
	printf("%d ", Listptr->seq);
	Listptr = Listptr->next;
  }
  printf("\n");
}

//$B%j%9%H$KF~$C$F$$$kL?Na?t$rJV$9(B
int
instqueue::get_ruu_num(void)
{
  return ruu_num;
}

//$B%j%9%H$KF~$C$F$$$k(BLoad/Store$BL?Na?t$rJV$9(B
int
instqueue::get_lsq_num(void)
{
  return lsq_num;
}

//$BJ,4t7k2L$N99?7(B
void
instqueue::set_bad_branch(INST_SEQ_TYPE branch_seq)
{
  struct INSTList *Listptr;
  Listptr = ListHead;
  bool flag = false;

  while( Listptr != NULL ) {
	if ( Listptr->branch_seq == branch_seq ) {
	  Listptr->branch_result = 2;
	  flag = true;
	} else if ( flag && Listptr->branch_seq != branch_seq ) {
	  return;
	}
	Listptr = Listptr->next;
  }
  return;
}


//$BJ,4t7k2L$N99?7(B
void
instqueue::set_good_branch(INST_SEQ_TYPE branch_seq)
{
  struct INSTList *Listptr;
  Listptr = ListHead;
  bool flag = false;

  while( Listptr != NULL ) {
	if ( Listptr->branch_seq == branch_seq ) {
	  Listptr->branch_result = 1;
	  flag = true;
	} else if ( flag && Listptr->branch_seq != branch_seq ) {
	  return;
	}
	Listptr = Listptr->next;
  }
  return;
}
