/*
  Writeback$B%$%Y%s%H$r=*N;$7$?L?Na$rJ];}$9$k!#(B
  $B3FL?Na$,%l%8%9%?$r99?7$9$k:]$NCM(B
  ($B7W;;7k2L$d%a%b%j$+$iFI$_=P$7$?CM(B)$B$rJ];}$7!"(B
  reorder buffer$B$NLr3d$rC4$&!#(B
  $BL?Na$OL?Na(BID$B$G>:=g$KJB$Y$i$l$k(B(in-order)$B!#(B
*/

#ifndef WB_BUFFER
#define WB_BUFFER

#include <assert.h>
#include <isis/host.h>
#include <isis/misc.h>
#include <isis/machine.h>
#include <isis/bpred.h>
#include <isis/instqueue.h>

typedef unsigned int INST_SEQ_TYPE;

class writeback_buffer
{
private:
  struct WBList {
	instqueue::INSTList_type *inst;    //$BL?Na(B
	//$B<B9T7k2L(BData
	int r_i;           //int$B7?(B
	sfloat_t r_f;      //float$B7?(B
	dfloat_t r_d;      //double$B7?(B
	sword_t r_1, r_2;  //signed int$B7?(B
	int time,          
	  flag,            //$B<B9T7k2L(BData$B$N7?(B
	  reg1, reg2,      //$B<B9T7k2L$r=q$-9~$`%l%8%9%?HV9f(B           
	  sim_cycle;       //$B%j%9%H$KDI2C$5$l$?;~9o(B
	struct WBList *next;
  };

  struct WBList *ListHead;
  struct WBList *ListTail;

 public:
  writeback_buffer();

  //$B%j%9%H$KDI2C(B ($BL?Na(BID$B=g$KJB$Y$i$l$k(B)
  void insertlist(instqueue::INSTList_type*, int, int, bool, sword_t, bool,
				  sword_t, bool, int, bool, sfloat_t, bool, dfloat_t, int);

  /* $B0z?t$H$7$FM?$($i$l$?L?Na(BID$B$r;}$DL?Na$N<B9T7k2L$rEO$9(B
	 $B3FL?Na$,%l%8%9%?$r99?7$9$k:]$K8F$S=P$5$l$k(B */
  void get_element(INST_SEQ_TYPE, sword_t*, sword_t*, int*,
				   sfloat_t*, dfloat_t*);

  //$B%j%9%H$+$i:o=|(B
  void deletelist(INST_SEQ_TYPE);
  void deletelist_after_this(INST_SEQ_TYPE);

  //$BL?Na$rJV$9(B
  instqueue::INSTList_type* ready_label(int);

  //$B0z?t$GM?$($i$l$?L?Na(BID$B$r;}$DL?Na$,%j%9%H$KB8:_$9$k$+(B
  bool is(INST_SEQ_TYPE);

  void printlist();

  /* $B0z?t$H$7$FM?$($i$l$?L?Na(BID$B$r;}$DL?Na$,!"(B
	 $B0z?t$H$7$FM?$($i$l$?%l%8%9%?HV9f$N%l%8%9%?$K(B
	 $B=q$-9~$`CM(B($B$=$NL?Na$N<B9T7k2L(B)$B$rEO$9(B
	 reorder buffer$B$NCM$r<hF@$7$?$$L?Na$K$h$C$F8F$S=P$5$l$k(B */
  void get_data(int, INST_SEQ_TYPE, bool*, sword_t*, bool*, sword_t*,
				bool*, int*, bool*, sfloat_t*, bool*, dfloat_t*, int);
};

#endif

