/*
  issue$B$5$l$?L?Na$r4IM}$9$k(Bexecution buffer$B$rI=$9%/%i%9!#(B
  $B<B9T$,=*N;$9$k;~9o(B(Functional Unit$B$G$N7W;;$,=*N;$9$k;~9o!"(B
  $B%m!<%+%k%a%b%j$X$N%"%/%;%9$,=*N;$9$k;~9o(B)$B=g$K%j%9%H$+$i(B
  $B:o=|$5$l$k(B(out-of-order)$B!#(B
*/

#ifndef EXEC_BUFFER
#define EXEC_BUFFER

#include <assert.h>
#include <isis/host.h>
#include <isis/misc.h>
#include <isis/machine.h>
#include <isis/bpred.h>
#include <isis/instqueue.h>

typedef unsigned int INST_SEQ_TYPE;

class exec_buffer
{
 private:
  struct EXList {
	instqueue::INSTList_type* inst;
	int check_time; 
	struct EXList *next;
  };

  struct EXList *ListHead;
  struct EXList *ListTail;
  
 public:
  exec_buffer();

  //$BL?Na$NEjF~(B
  void insertlist(instqueue::INSTList_type*);

  //$BL?Na$rJV$9(B
  instqueue::INSTList_type* ready_label(int);

  //$BL?Na$N:o=|(B
  void deletelist(INST_SEQ_TYPE);
  void deletelist_after_this(INST_SEQ_TYPE);

  void printlist(void);
};

#endif
