/*
  RUU$B$*$h$S(Breservation station$B$rI=$9%/%i%9$G$"$k!#(B
  $B3FL?Na$KBP$9$k$"$i$f$k>pJs$rJ];}$7!"(Bin-order$B$GJB$Y$i$l$k!#(B
*/
#ifndef INST_QUEUE
#define INST_QUEUE

#include <assert.h>
#include <isis/host.h>
#include <isis/misc.h>
#include <isis/machine.h>
#include <isis/bpred.h>

typedef unsigned int INST_SEQ_TYPE;

class instqueue
{
 private:
  int ruu_num, lsq_num;

 public:
  struct INSTList {
	md_inst_t inst;            //$BL?Na(B
	INST_SEQ_TYPE seq,         //$BL?Na(BID
	  branch_seq;              //$B<+J,$,=>$&J,4tL?Na$N(BID
	//bool set;
	bool adr_flag;             //$B%a%b%j%"%/%;%9%"%I%l%9$r7W;;$9$kL?Na$+(B
	md_addr_t prev_branch_PC, now_PC, next_PC, pred_PC;  
	bpred_update_t *dir;       //branch predictor$B$K4X$o$kCM(B
	int in1, in2, in3, in4, out1, out2, out3; //$B;HMQ$9$k%l%8%9%?(B
	int try_issue_time;        
	struct INSTList *next;      
	bool mem_flag;             //$B%a%b%j%"%/%;%9$9$kL?Na$+(B
	int branch_result;         //$B<+J,$,=>$&J,4tL?Na$NJ,4t7k2L(B
	struct res_template *fu;   //$B<+J,$,;HMQ$9$k(BFunctional Unit
	bool exec_ok;              //issue$BL$$G!"(Bissue$B2D$J$i(Btrue
	md_addr_t adr, adr2;       //$B%a%b%j%"%/%;%9%"%I%l%9(B
	int adr_area;              //$B%a%b%j%"%/%;%9$9$k:]$N(Bbyte$BI}(B
	bool this_clock_not_exec;
	int exec_time;             //$BL?Na$N<B9T$,=*N;$9$k;~9o(B
	bool l_or_s;               //Load$BL?Na(B or Store$BL?Na(B
	int calc_time;             //$B%a%b%j%"%/%;%9%"%I%l%9$r7W;;$7$?;~9o(B
	//$B%a%b%j$+$iFI$_=P$7$?CM(B
	word_t load_data, load_data2; //unsigned int$B7?(B
	half_t load_data_half;        //unsigned short$B7?(B
	byte_t load_data_byte;	      //unsigned char$B7?(B
	bool load_flag,            //$B%a%b%j$+$i(BData$B$rFI$_=P$9L?Na$+(B
	  load_finish;             //$B%a%b%j$+$i$N(BData$B$O3NJ]:Q$_$+(B
	//Store$BL?Na$+$iN.$5$l$F$-$?(BData
	sword_t lsq_data, lsq_data2;
	half_t lsq_data_h;
	byte_t lsq_data_b;
	bool lsq_data_flag;        //Store$B$+$i(BData$B$,N.$5$l$F$-$F$$$k$+(B
	bool use_lsq_flag;
	//bool addr_order_ok;
	//int depend_num;           
  };

  struct INSTList *ListHead;
  struct INSTList *ListTail;
  typedef INSTList INSTList_type;

 public:
  instqueue();

  //$BL?Na$NEjF~(B
  void insert(md_inst_t, INST_SEQ_TYPE, bool, md_addr_t, md_addr_t, md_addr_t, 
			  md_addr_t,bpred_update_t *,
			  int, int, int, int, int, int, int, bool, bool, INST_SEQ_TYPE);

  //issue$B2D$JL?Na$rJV$9(B
  INSTList_type* return_reservation_station_inst(int);

  //$BL?Na$rJV$9(B
  INSTList_type* return_inst(INST_SEQ_TYPE);
  INSTList_type* return_after_this(INST_SEQ_TYPE);

  //$BL?Na$NGK4~(B
  void deletelist(INST_SEQ_TYPE);
  void printlist();

  //$B%j%9%H$KF~$C$F$$$kL?Na?t$rJV$9(B
  int get_ruu_num(void);

  //$B%j%9%H$KF~$C$F$$$k(BLoad/Store$BL?Na?t$rJV$9(B
  int get_lsq_num(void);

  //$BJ,4t7k2L$N99?7(B
  void set_good_branch(INST_SEQ_TYPE);
  void set_bad_branch(INST_SEQ_TYPE);
};

#endif
