/*
  isim_processor$B$H30It%7%9%F%`$H$N4V$G$d$j<h$j$5$l$k%Q%1%C%H$rI=$9(B
*/

#ifndef ISIM_BUS_PACKET_H
#define ISIM_BUS_PACKET_H

#include <cstddef>
#include <iostream>
#include <isis/packet.h>
#include <isis/host.h>
#include <isis/misc.h>
#include <isis/machine.h>

using namespace std;

class isim_bus_packet: public packet
{
 private:
  typedef packet inherited;

  md_addr_t addr;       //$B%a%b%j%"%/%;%9%"%I%l%9(B
  //$B%G!<%?(B
  word_t data, data2;   //unsigned int$B7?(B
  half_t data_half;     //unsigned short$B7?(B
  byte_t data_byte;     //unsigned char$B7?(B
  int data_size,        //$B%a%b%j%"%/%;%9$9$k:]$N(Bbyte$BI}(B
	inst_id,            //$BL?Na(BID
	rw,                 //Read or Write or Reply
	puid;               //$BAw?.85%W%m%;%C%5$N(BID
  
 public:
  isim_bus_packet(void);
  virtual ~isim_bus_packet(void){};
  
  //$B%Q%1%C%H$N=i4|2=(B
  void reset_packet(void);
  
  //$B%Q%1%C%H$NFbMF99?7(B
  void set_addr(md_addr_t a) { addr = a; }
  void set_data(md_addr_t a) { data = a; }
  void set_data2(md_addr_t a) { data2 = a; }
  void set_data_half(half_t a) { data_half = a; }
  void set_data_byte(byte_t a) { data_byte = a; }
  void set_data_size(int a) { data_size = a; }
  void set_inst_id(int a) { inst_id = a; }
  void set_puid(int a) { puid = a; }
  void set_read(void) { rw = 0; }
  void set_write(void) { rw = 1; }
  void set_reply(void) { rw = 2; }

  //$B%Q%1%C%H$NFbMF;2>H(B
  md_addr_t ref_addr(void) { return addr; }
  word_t ref_data(void) { return data; }  
  word_t ref_data2(void) { return data2; }
  half_t ref_data_half(void) { return data_half; }  
  byte_t ref_data_byte(void) { return data_byte; }  
  int ref_inst_id(void) { return inst_id; }
  int ref_puid(void) { return puid; }
  int ref_rw(void) { return rw; }
  bool is_read(void) { return (rw == 0); }
  bool is_write(void) { return (rw == 1); }
  bool is_reply(void) { return (rw == 2); }
  int ref_data_size(void) { return data_size; }

  void output(ostream& os) const {
	if(inst_id != -1){
	  os << "INST_ID: 0x" << hex << inst_id << " ";
	  switch(rw){
	  case 0:
		os << "Read  ";
		os << "0x" << hex << addr << " ";
		break;
	  case 1:
		os << "Write ";
		os << "0x" << hex << addr << " ";

		break;
	  case 2:
		os << "Reply ";
		break;
	  }
	  if(rw == 1 || rw ==2){
	  os << "Data : 0x" << hex ;
	  switch(data_size){
	  case 1:
		os << data_byte << " ";
		os << dec << "(" << (char)data_byte << ")";
		break;
	  case 2:
		os << data_half << " ";
		os << dec << "(" << (short int)data_half << ")";
		break;
	  case 4:
		os << data << " ";
		os << dec << "(" << data << ")";
		break;
	  case 8:
		{
		  os << hex << "0x" << data2 << "_" << data << " ";
		  //		  double tmp;
		  //*(volatile unsigned int*)(&tmp) = data;
		  //		  *(volatile unsigned int*)(&tmp+1) = data2;
		  //		  os << dec << "HOGE Check Endian (" << tmp << ")";
		}
		break;
	  }
	  }
	}
  }
};

#endif 
