#include "isim_bus_port.h"

void
isim_bus_port::set_addr(md_addr_t a)
{
  if(!have_packet()){ 
	packet_type *tmp = new packet_type;
	inherited::put((packet*)tmp);
  } 
  packet_reference().set_addr(a);
}

void
isim_bus_port::set_data(md_addr_t a)
{
  if(!have_packet()){ 
	packet_type *tmp = new packet_type;
	inherited::put((packet*)tmp);
  }
  packet_reference().set_data(a);
}

void
isim_bus_port::set_data2(md_addr_t a)
{
  if(!have_packet()){ 
	packet_type *tmp = new packet_type;
	inherited::put((packet*)tmp);
  }
  packet_reference().set_data2(a);
}

void
isim_bus_port::set_data_half(half_t a)
{
  if(!have_packet()){ 
	packet_type *tmp = new packet_type;
	inherited::put((packet*)tmp);
  }
  packet_reference().set_data_half(a);
}

void
isim_bus_port::set_data_byte(byte_t a)
{
  if(!have_packet()){ 
	packet_type *tmp = new packet_type;
	inherited::put((packet*)tmp);
  }
  packet_reference().set_data_byte(a);
}

void
isim_bus_port::set_data_size(int a)
{
  if(!have_packet()){ 
	packet_type *tmp = new packet_type;
	inherited::put((packet*)tmp);
  } 
  packet_reference().set_data_size(a);
}

void
isim_bus_port::set_inst_id(int a)
{
  if(!have_packet()){ 
	packet_type *tmp = new packet_type;
	inherited::put((packet*)tmp);
  } 
  packet_reference().set_inst_id(a);
}

void
isim_bus_port::set_puid(int a)
{
  if(!have_packet()){ 
	packet_type *tmp = new packet_type;
	inherited::put((packet*)tmp);
  } 
  packet_reference().set_puid(a);
}

void
isim_bus_port::set_read(void)
{
  if(!have_packet()){ 
	packet_type *tmp = new packet_type;
	inherited::put((packet*)tmp);
  } 
  packet_reference().set_read();
}

void
isim_bus_port::set_read_detail(md_addr_t addr, int inst_id, int size, int puid)
{
  set_read();
  set_addr(addr);
  set_inst_id(inst_id);
  set_data_size(size);
  set_puid(puid);
}


void
isim_bus_port::set_write(void)
{
  if(!have_packet()){ 
	packet_type *tmp = new packet_type;
	inherited::put((packet*)tmp);
  } 
  packet_reference().set_write();
}

void
isim_bus_port::set_write_detail(md_addr_t addr, word_t data1, word_t data2,
								half_t half, byte_t byte, int inst_id,
								int size, int puid)
{
  set_write();
  set_addr(addr);
  set_data(data1);
  set_data2(data2);
  set_data_half(half);
  set_data_byte(byte);  
  set_inst_id(inst_id);
  set_data_size(size);
  set_puid(puid);
}

void
isim_bus_port::set_reply(void)
{
  if(!have_packet()){ 
	packet_type *tmp = new packet_type;
	inherited::put((packet*)tmp);
  } 
  packet_reference().set_reply();
}

void
isim_bus_port::reset_packet(void)
{
  if(!have_packet()){ 
	packet_type *tmp = new packet_type;
	inherited::put((packet*)tmp);
  }
  packet_reference().reset_packet();
}
