/* -*- C++ -*-
 *
 * <<< arg.h >>>
 *
 * --- Command-line argument parser class 'argument_parser'
 *     Copyright (C) 1997-2000 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#ifndef ARG_H
#define ARG_H 1
#include<stdio.h>

class arg
{
private:
  typedef arg thisclass;
  char* short_index;
  char** short_value;
  char** long_index;
  char** long_value;
  char** args;
  void assign(const thisclass&);
public:
  arg(void);
  explicit arg(const char* const*);
  arg(const thisclass&);
  ~arg();
  void set(const char* const*);
  void clear(void);
  const char* operator[](char) const;
  void output(void);
};

#endif /* ARG_H */
