/*
  isim_processor$B$H30It%7%9%F%`$H$N@\B3$K;HMQ$5$l$k%]!<%H$rI=$9!#(B
  $BF~NO$G$-$k%Q%1%C%H$OFbJq$9$k(Bisim_bus_packet$B%/%i%9$GDj5A$5$l$F$$$k(B
  $B$b$N$N$_$G$"$k!#(B
*/

#ifndef ISIM_BUS_PORT_H
#define ISIM_BUS_PORT_H

#include <iostream>
#include <isis/port.h>
#include <isis/bus_packet_base.h>
#include <isis/isim_bus_packet.h>

class isim_bus_port : public port
{
 private:
  typedef port inherited;
  typedef isim_bus_packet packet_type;

 public:
  isim_bus_port(void){};
  virtual ~isim_bus_port(void){}
 
  //port$B$KB8:_$9$k%Q%1%C%H$N=i4|2=(B
  void reset_packet(void);

  //port$B$KB8:_$9$k%Q%1%C%H$N99?7(B
  void set_addr(md_addr_t);
  void set_data(word_t);
  void set_data2(word_t);
  void set_data_half(half_t);
  void set_data_byte(byte_t);
  void set_data_size(int);
  void set_inst_id(int);
  void set_puid(int);
  void set_read(void);
  void set_write(void);
  void set_reply(void);
  void set_read_detail(md_addr_t, int, int, int);
  void set_write_detail(md_addr_t, word_t, word_t,
						half_t, byte_t, int, int, int);

  //port$B$KB8:_$9$k%Q%1%C%H$N;2>H(B
  md_addr_t addr(void) { return packet_reference().ref_addr(); }
  word_t data(void) { return packet_reference().ref_data(); }
  word_t data2(void) { return packet_reference().ref_data2(); }
  half_t data_half(void) { return packet_reference().ref_data_half(); }
  byte_t data_byte(void) { return packet_reference().ref_data_byte(); }
  int data_size(void) { return packet_reference().ref_data_size(); }
  int inst_id(void) { return packet_reference().ref_inst_id(); }
  int puid(void) { return packet_reference().ref_puid(); }
  int rw(void) { return packet_reference().ref_rw(); }
  bool is_read(void) { return packet_reference().is_read(); }
  bool is_write(void) { return packet_reference().is_write(); }
  bool is_reply(void) { return packet_reference().is_reply(); }

  const packet_type& packet_reference(void) const { return *look(); }
  packet_type& packet_reference(void) { return *look(); }
  const packet_type* look(void) const
	{
	  assert(have_packet());
	  return (packet_type*)(inherited::look()); 
	}
  packet_type* look(void)
	{ 
   	  assert(have_packet());
	  return (packet_type*)(inherited::look()); 
	}
  void output(ostream& os) const {
	if(have_packet()){
	  os << *(packet_type*)(inherited::look());
	}
  }
};

#endif
