#include "shared_bus.h"
#include <isis/address.h>

#define GET_SHBUS_STATISTICS

shared_bus::shared_bus()
{
#ifdef GET_SHBUS_STATISTICS //$BE}7W%G!<%?(B
  clock_flag = false;
  clock_ = 0;
  access_num = 0;
#endif
}


//PU$BB&$N%]!<%H$H%a%b%jB&$N%]!<%H$+$i!"%Q%1%C%H$r<hF@$9$k(B
void
shared_bus::get_packet(void)
{

#ifdef GET_SHBUS_STATISTICS //$BE}7W%G!<%?(B
  if ( clock_flag ) 
	clock_++;
#endif

  //PU$BB&$N$9$Y$F$N%]!<%H$KBP$7$F(B
  for ( unsigned int i = 0; i < from_pu_port.size(); i++ ) {
	if ( from_pu_port[i].have_packet()  //$B%]!<%H$K%Q%1%C%H$,$"$k(B
		 /* $B%]!<%H$K$"$k%Q%1%C%H$,!"=i4|>uBV$G$O$J$$(B
			$B$D$^$j!"?7$7$$%Q%1%C%H$G$"$k(B */
		 && from_pu_port[i].inst_id() != -1 
		 /* $B%a%b%j$+$i$N%Q%1%C%H$G$O$J$$(B
			$B$D$^$j!"(BPU$B$+$i%Q%1%C%H$G$"$k(B */
		 && !from_pu_port[i].is_reply() ) {

	  //$B%]!<%H$K$"$k%Q%1%C%H$r<hF@$7!"%-%e!<$KDI2C$9$k(B
	  queue.insertlist(from_pu_port[i].inst_id(),
					   from_pu_port[i].addr(),
					   from_pu_port[i].data(),
					   from_pu_port[i].data2(),
					   from_pu_port[i].data_half(),
					   from_pu_port[i].data_byte(),
					   from_pu_port[i].data_size(),
					   from_pu_port[i].rw(),
					   from_pu_port[i].puid(),
					   0,
					   0); //0:PU$B$+$i%a%b%j$X$N%Q%1%C%H(B

	  /* $B%]!<%H$K$"$k%Q%1%C%H$r=i4|2=$9$k(B
		 $B=i4|2=$9$k$3$H$K$h$j!"(BPU$B$O<!$NMW5a$rH/9T$G$-$k(B */
	  from_pu_port[i].reset_packet();
	}
  }

  //$B%a%b%jB&$N%]!<%H$KBP$7$F(B
  if ( mm_port.have_packet() //$B%]!<%H$K%Q%1%C%H$,$"$k(B
	   /* $B%]!<%H$K$"$k%Q%1%C%H$,!"=i4|>uBV$G$O$J$$(B
		  $B$D$^$j!"%a%b%j$+$i$N?7$?$J%Q%1%C%H$G$"$k(B */
	   && mm_port.inst_id() != -1
	   && mm_port.is_reply() ) { // $B%a%b%j$+$i$N%Q%1%C%H$G$"$k(B
	
	//$B%]!<%H$K$"$k%Q%1%C%H$r<hF@$7!"%-%e!<$KDI2C$9$k(B
	queue.insertlist(mm_port.inst_id(),
					 mm_port.addr(),
					 mm_port.data(),
					 mm_port.data2(),
					 mm_port.data_half(),
					 mm_port.data_byte(),
					 mm_port.data_size(),
					 mm_port.rw(),
					 mm_port.puid(),
					 0,
					 1); //1:$B%a%b%j$+$i(BPU$B$X$N%Q%1%C%H(B

	/* $B%]!<%H$K$"$k%Q%1%C%H$r=i4|2=$9$k(B
	   $B=i4|2=$9$k$3$H$K$h$j!"%a%b%j$O<!$NMW5a$rH/9T$G$-$k(B */
	mm_port.reset_packet();
  }
}


void
shared_bus::send_packet(void)
{
  md_addr_t addr;
  md_addr_t data, data2;
  half_t data_half;
  byte_t data_byte;
  int rw, inst_id, data_size;
  int puid;
  size_t time;
  bool flag;

  /*$B%-%e!<$K%Q%1%C%H$,F~$C$F$$$k>l9g$K$O!"(B
	$B%-%e!<$N@hF,%Q%1%C%H$N>pJs$r<hF@$9$k(B */
  if ( queue.get_data(&inst_id, &addr, &data, &data2,
					&data_half, &data_byte, &data_size,
					&rw, &puid, &time, &flag)){
	if ( flag ) { //$B%a%b%j$+$i(BPU$B$X$N%Q%1%C%H(B
	  /* $B%Q%1%C%H$N(Bpuid$B$K5-:\$5$l$?(BID$B$r;}$D(BPU$B$N%]!<%H$K(B
		 $B%Q%1%C%H$NH/9T$r;n$_$k(B */
	  for ( int j = puid*each_pu_port_num; j < (puid+1)*each_pu_port_num; j++){
		if ( !to_pu_port[j].have_packet() //$B%]!<%H$K%Q%1%C%H$,$J$$(B
			 || //$B$^$?$O(B
			 ( to_pu_port[j].have_packet() //$B%]!<%H$K%Q%1%C%H$,$"$k(B
				  && to_pu_port[j].inst_id() == -1 ) ) { //$B=i4|>uBV$G$"$k(B

		  //$B%]!<%H$K%Q%1%C%H$rH/9T$9$k(B
		  to_pu_port[j].set_inst_id(inst_id);
		  to_pu_port[j].set_addr(addr);
		  to_pu_port[j].set_data(data);
		  to_pu_port[j].set_data2(data2);
		  to_pu_port[j].set_data_half(data_half);
		  to_pu_port[j].set_data_byte(data_byte);
		  to_pu_port[j].set_data_size(data_size);
		  /* set_reply():
			 $B%a%b%j$+$i$N%Q%1%C%H$G$"$k$3$H$r(BPU$B$KDLCN$9$k(B */
		  to_pu_port[j].set_reply(); 
		  to_pu_port[j].set_puid(puid);

		  //$BAw?.$7$?%Q%1%C%H$N>pJs$r%-%e!<$+$i:o=|$9$k(B
		  queue.deletelist(inst_id, addr, puid);

#ifdef GET_SHBUS_STATISTICS //$BE}7W%G!<%?(B
		  if ( clock_flag )
			access_num++;
		  
		  if ( addr == 0xd0000000 && !clock_flag )
			clock_flag = true;
		  
		  if ( addr == 0xd0000100 && clock_flag == true ) {
			clock_flag = false;
			cout << "SHBUS "
				 << dec << clock_ << " "
				 << access_num << endl;
		  }
#endif

		  break; //$B%Q%1%C%H$,Aw?.$G$-$?$i=*N;(B
		} else {
		  assert(0);
		}
	  }
	} else {  //PU$B$+$i%a%b%j$X$N%Q%1%C%H(B
	  if ( !mm_port.have_packet() //$B%]!<%H$K%Q%1%C%H$,$J$$(B
		   || //$B$^$?$O(B
		   ( mm_port.have_packet() //$B%]!<%H$K%Q%1%C%H$,$"$k(B
			 && mm_port.inst_id() == -1 ) ) { //$B=i4|>uBV$G$"$k(B

		//$B%]!<%H$K%Q%1%C%H$rH/9T$9$k(B
		mm_port.set_inst_id(inst_id);
		mm_port.set_addr(addr);
		mm_port.set_data(data);
		mm_port.set_data2(data2);
		mm_port.set_data_half(data_half);
		mm_port.set_data_byte(data_byte);
		mm_port.set_data_size(data_size);
		//READ$BMW5a$J$N$+!"(BWRITE$BMW5a$J$N$+$r%a%b%j$KDLCN$9$k(B
		if ( rw == 0 ) mm_port.set_read();
		if ( rw == 1 ) mm_port.set_write();
		mm_port.set_puid(puid);

		//$BAw?.$7$?%Q%1%C%H$N>pJs$r%-%e!<$+$i:o=|$9$k(B
		queue.deletelist(inst_id, addr, puid);

#ifdef GET_SHBUS_STATISTICS //$BE}7W%G!<%?(B
		if ( clock_flag )
		  access_num++;
#endif		

	  }
	}
  }
}

