#ifndef ISIM_SHARED_BUS_H
#define ISIM_SHARED_BUS_H

using namespace std;

#include <isis/isim_bus_port.h>
#include "shared_memory_access_queue.h"
#include <isis/machine.h>

class shared_bus
{
 private:
  typedef isim_bus_port isim_bus_port_type;
  vector<isim_bus_port_type> to_pu_port, from_pu_port; 
  isim_bus_port_type mm_port;
  int each_pu_port_num;
  shared_memory_access_queue queue;

  //$BE}7W%G!<%?MQ(B
  size_t access_num, clock_;
  bool clock_flag;

 public:
  shared_bus();

  //$B%Q%1%C%H$N<u?.(B
  void get_packet(void);

  //$B%Q%1%C%H$NAw?.(B
  void send_packet(void);

  //$B%]!<%H$N(Bresize
  void set_num_of_pu_port(int a) {
	to_pu_port.resize(a);    //PU$B$X$NAw?.%]!<%H(B
	from_pu_port.resize(a);  //PU$B$+$i$N<u?.%]!<%H(B
  }

  //PU$BKh$N%]!<%H?t<hF@(B
  void set_each_pu_port_num(int a)
  { each_pu_port_num = a; }

  const isim_bus_port_type& ref_to_pu_port(int a) const
  { return to_pu_port[a]; }
  isim_bus_port_type& ref_to_pu_port(int a)
  { return to_pu_port[a]; }  
  const isim_bus_port_type& ref_from_pu_port(int a) const
  { return from_pu_port[a]; }
  isim_bus_port_type& ref_from_pu_port(int a)
  { return from_pu_port[a]; }  
  const isim_bus_port_type& ref_mm_port(void) const
  { return mm_port; }
  isim_bus_port_type& ref_mm_port(void)
  { return mm_port; }  
};

#endif
