#include <isis/address.h>
#include "shared_memory.h"
#define MEM_ACCESS_LATENCY 1
#define GET_SHMEM_STATISTICS

shared_memory::shared_memory()
{
  state = READY;
  clock_ = 0;
  overflow_counter = 0;
  total_stall_time = 0;
  clock_flag = false;
  access_num = 0;
}


void
shared_memory::clock(void)
{
  word_t tmp_data;
  md_addr_t tmp, mem_addr;

#ifdef GET_SHMEM_STATISTICS //$BE}7W%G!<%?(B
  if ( clock_flag )
	clock_++;
#endif

  //shared bus$B$H@\B3$5$l$F$$$k%]!<%H$KBP$7$F(B
  if ( shbus_port.have_packet() //$B%Q%1%C%H$,$"$k(B
	   && shbus_port.inst_id() != -1 ) { /* $B%Q%1%C%H$,=i4|>uBV$G$J$$(B
											$B$D$^$j!"?7$7$$%Q%1%C%H(B */

	//$B%]!<%H$K$"$k%Q%1%C%H$r<hF@$7!"%-%e!<(BA$B$KDI2C$9$k(B
	queue_A.insertlist(shbus_port.inst_id(),
				   shbus_port.addr(),
				   shbus_port.data(),
				   shbus_port.data2(),
				   shbus_port.data_half(),
				   shbus_port.data_byte(),
				   shbus_port.data_size(),
				   shbus_port.rw(),
				   shbus_port.puid(),
				   clock_, 0);

#ifdef GET_SHMEM_STATISTICS //$BE}7W%G!<%?(B
	if ( clock_flag )
	  access_num++;
	if ( shbus_port.addr() == 0xd0000000 && !clock_flag )
	  clock_flag = true;
#endif
	
	/* $B%]!<%H$K$"$k%Q%1%C%H$r=i4|2=$9$k(B
	   $B=i4|2=$9$k$3$H$K$h$j<!$NMW5a$rH/9T$G$-$k(B */
	shbus_port.reset_packet();
  }
  
  switch(state){
  case READY:
	/*$B%-%e!<(BA$B$K%Q%1%C%H$,F~$C$F$$$k>l9g$K$O!"(B
	  $B%-%e!<(BA$B$N@hF,%Q%1%C%H$N>pJs$r<hF@$9$k(B */
	if ( queue_A.get_data(&inst_id, &addr, &data, &data2, &data_half,
						&data_byte, &data_size, &rw, &puid, &time, &flag) ) {

#ifdef GET_SHMEM_STATISTICS //$BE}7W%G!<%?(B
	  if ( clock_flag ) {
		/* $B%-%e!<(BA$B$KEjF~$5$l$F$+$i(B
		   $B%a%b%j%"%/%;%9$,;O$^$k$G$N7P2a;~4V(B */
		total_stall_time += (clock_ - time); 
		if ( total_stall_time > 1000000000 ) { //$B7e0n$lBP:v(B
		  overflow_counter++;
		  total_stall_time = total_stall_time - 1000000000;
		}
	  }
#endif
	  latency = 1;
	  // #define$B$G@_Dj$7$?%a%b%j%"%/%;%9%l%$%F%s%7$KC#$7$F$$$?$i(B
	  if ( latency == MEM_ACCESS_LATENCY )
		state = ACCESS; //$B%a%b%j%"%/%;%9(B
	  else 
		state = LATENCY; //$B%a%b%j%"%/%;%9%l%$%F%s%7$KC#$9$k$^$GBT$D(B

	  /*$B%Q%1%C%H$N>pJs$OJQ?t$KF~$C$F$$$k$N$G!"(B
		$B%Q%1%C%H$N>pJs$r%-%e!<$+$i:o=|$9$k(B */
	  queue_A.deletelist(inst_id, addr, puid);
	}
	break;
  case LATENCY: // $B@_Dj$7$?%l%$%F%s%7$KC#$9$k$^$GBT$D(B
	latency++;
	if ( latency == MEM_ACCESS_LATENCY )
	  state = ACCESS;
	break;
  case ACCESS: //$B%a%b%j%"%/%;%9(B	
	if ( rw == 1 ) { //WRITE$BMW5a(B
	  if ( data_size == 1 ) {
		tmp = addr%sizeof(word_t);
		mem_addr = addr - tmp;
		tmp_data = mem->read(mem_addr);
		tmp_data = tmp_data & ~( 0xff << tmp*8 );
		data = tmp_data | ( data_byte << tmp*8 );
		mem->write(addr, data);
	  } else if ( data_size == 2 ) {
		tmp = addr%sizeof(word_t);
		mem_addr = addr - tmp;
		tmp_data = mem->read(mem_addr);
		tmp_data = tmp_data & ~( 0xffff << tmp*8 );
		data = tmp_data | ( data_half << tmp*8 );
		mem->write(addr, data);		  
	  } else if ( data_size == 4 ) {
		mem->write(addr, data);		  
	  } else if ( data_size == 8 ) {
		mem->write(addr, data);
		mem->write(addr + 4, data2);
	  }
	} else if ( rw == 0 ) { //READ$BMW5a(B
	  if ( data_size == 1 ) { 
		tmp = addr%sizeof(word_t);
		mem_addr = addr - tmp;
		tmp_data = mem->read(mem_addr);
		data_byte = ( tmp_data & ( 0xff << (tmp*8)) ) >> (tmp*8);
	  } else if ( data_size == 2 ) {
		tmp = addr%sizeof(word_t);
		mem_addr = addr - tmp;
		tmp_data = mem->read(mem_addr);
		data_half = ( tmp_data & ( 0xffff << (tmp*8)) ) >> (tmp*8);
	  } else if ( data_size == 4 ) {
		data = mem->read(addr);
		if ( addr >= FAD_MEM_TOP
			 && addr <= FAD_MEM_BOTTOM ) { //Fetch and Dec$B%"%/%;%9(B
		  /* $BFI$_=P$7$?(BData$B$+$i(B1$B0z$$$?CM$r=q$-9~$`(B */
		  mem->write(addr, data - 1 ); 
		} else if ( addr >= TAS_MEM_TOP
					&& addr <= TAS_MEM_BOTTOM ) { //Test and Set$B%"%/%;%9(B
		  if ( data == 1 ) { //$BFI$_=P$7$?(BData$B$,(B 1
			mem->write(addr, 0 ); //0 $B$r=q$-9~$`(B
			data = 0; //PU$B$K$O(B0$B$rJV$9(B
		  } else if ( data == 0 ) { //$BFI$_=P$7$?(BData$B$,(B 0
			data = 1; //PU$B$K$O(B1$B$rJV$9(B
		  }
		}
	  } else if ( data_size == 8 ) {
		data = mem->read(addr);
		data2 = mem->read(addr + 4);
	  }

	  //$BFI$_=P$7$?(BData$B$K4X$9$k>pJs$r%-%e!<(BB$B$KDI2C(B
	  queue_B.insertlist(inst_id, addr, data, data2,
					  data_half, data_byte, 0, 0, puid, 0, 0);
	}
	state = READY;
  default:
	break;
  }


  /*$B%-%e!<(BB$B$K%Q%1%C%H$,F~$C$F$$$k>l9g$K$O!"(B
	$B%-%e!<(BB$B$N@hF,%Q%1%C%H$N>pJs$r<hF@$9$k(B */
  if ( queue_B.get_data(&send_inst_id, &send_addr, &send_data, &send_data2,
						&send_data_half, &send_data_byte, &send_data_size,
						&send_rw, &send_puid, &send_time, &send_flag)){
	//shared bus$B$H@\B3$5$l$F$$$k%]!<%H$KBP$7$F(B
	if ( !shbus_port.have_packet() //$B%Q%1%C%H$,$J$$(B
		 || //$B$^$?$O(B
		 ( shbus_port.have_packet() //$B%Q%1%C%H$,$"$k(B
			  && shbus_port.inst_id() == -1 ) ) { //$B$=$N%Q%1%C%H$,=i4|>uBV(B

	  //$B%a%b%j$+$iFI$_=P$7$?(BData$B$r4^$`%Q%1%C%H$r%]!<%HH/9T$9$k(B	  
	  shbus_port.set_inst_id(send_inst_id);
	  shbus_port.set_addr(send_addr);
	  shbus_port.set_data(send_data);
	  shbus_port.set_data2(send_data2);
	  shbus_port.set_data_half(send_data_half);
	  shbus_port.set_data_byte(send_data_byte);
	  /* set_reply():
		 $B%a%b%j$+$i$N%Q%1%C%H$G$"$k$3$H$r(BPU$B$KDLCN$9$k(B */
	  shbus_port.set_reply();
	  shbus_port.set_puid(send_puid);

	  //$BAw?.$7$?%Q%1%C%H$N>pJs$r%-%e!<$+$i:o=|$9$k(B
	  queue_B.deletelist(send_inst_id, send_addr, send_puid);	

#ifdef GET_SHMEM_STATISTICS //$BE}7W%G!<%?(B
	  if ( send_addr == 0xd0000100 && clock_flag == true ) {
		clock_flag = false;
		cout << "MEM "
			 << dec << clock_ << " "
			 << access_num << " "
			 << overflow_counter << " "
			 << total_stall_time  << endl;
	  }
#endif

	}
  }
}
