#include "address.h"

static unsigned int* barrier_table;
static unsigned int* barrier_fad_table;
static unsigned int* barrier_adr1;
static unsigned int* barrier_adr2;
static unsigned int* barrier_adr3;
static unsigned int* barrier_end;
static unsigned int* barrier_fad1;
static unsigned int* barrier_fad2;
static int punum, puid, barrier_start_flag = 0;

static unsigned long seed;

static void barrier_init(void)
{
  const int key = 0x12345678; /* magic key */
  punum = get_punum();
  puid = get_puid();
  
  if (punum == 1)
	return;
  
  barrier_table
	= (unsigned int*)shared_addr_for_sync_allocate(sizeof(unsigned int));

  barrier_fad_table
	= (unsigned int*)fad_addr_allocate(sizeof(unsigned int));

  barrier_end = barrier_table;
  barrier_adr1 = barrier_table + 1;
  barrier_adr2 = barrier_table + 2;
  barrier_adr3 = barrier_table + 3;
  barrier_fad1 = barrier_fad_table;
  barrier_fad2 = barrier_fad_table + 1;

#ifdef VERBOSE
  printf("barrier init start[%d] \n", puid);
#endif
  
  
  if (puid == 0) {
	*barrier_fad1 = punum;	// counter-1 
	*barrier_adr1 = 0;		// key-1
	*barrier_adr3 = key;	// initialize is finished
  } else {
	while (*barrier_adr3 != key){}
  }

  barrier_start_flag = 1;

#ifdef VERBOSE
  printf("barrier init end[%d] \n", puid);
#endif

}

void barrier(void)
{
  unsigned int *a1, *a2, *f1, *f2;
  int tmp;

  if (!barrier_start_flag)
	barrier_init();

  if (punum == 1)
	return;

  a1 = barrier_adr1;
  a2 = barrier_adr2;
  f1 = barrier_fad1;
  f2 = barrier_fad2;
  tmp = *f1;

#ifdef VERBOSE
  if(get_puid() == 0){
	printf("Barrier in\n");
  }
#endif

  if (tmp > 1) { // counter-1
	// not last processor 
#ifdef VERBOSE
	printf("Barrier [%d] barrier0 wait val %d  \n", get_puid(), tmp);
#endif
	while (!(*a1)) {}    // wait last processor using key-1
	
#ifdef VERBOSE
	printf("Barrier [%d] barrier0 escape  val %d  \n", get_puid(), tmp);
#endif
	
  } else if(tmp <= 1){
#ifdef VERBOSE
	printf("Barrier [%d] barrier0 break val %d \n", get_puid(), tmp);
#endif
	// last processor
	*f2 = punum;		// reset counter-2,
	*a2 = 0;			// locks key2,
	*a1 = 1;			// unlocks key1
	//allow other processor to go to next step
  }
  
  tmp = *f2;
#ifdef VERBOSE
  printf("Barrier [%d] barrier second start \n", get_puid());
#endif
  if (tmp > 1) {					// counter-2
	// not last processor
#ifdef VERBOSE
	printf("Barrier [%d] barrier1 wait val %d  \n", get_puid(), tmp);
#endif
	while (!(*a2)) {}			// wait last processor using key-2 
#ifdef VERBOSE
	printf("Barrier [%d] barrier1 escape \n", get_puid());
#endif
  } else if(tmp <= 1){
	// last processor
#ifdef VERBOSE
	printf("Barrier [%d] barrier1 break val %d \n", get_puid(), tmp);
#endif

	*f1 = punum;				// last processor reset counter-1,
	*a1 = 0;					// locks key-1,
	*a2 = 1;					// unlocks key-2
  }
#ifdef VERBOSE
  printf("Barrier [%d] barrier end \n", get_puid());
  if(get_puid() == 0){
	printf("Barrier out \n");
  }
#endif
  *barrier_end;					// dummy address
}
