#include "address.h"

#ifndef NULL
#define NULL 0
#endif

static unsigned int *shared_memory_address;
static unsigned int *shared_memory_end;
static int shared_addr_allocate_start_flag = 0;
static unsigned int *shared_memory_freearea;
static void shared_addr_for_sync_allocate_init(void);

static void shared_addr_for_sync_allocate_init(void)
{
  shared_memory_address = (unsigned int*) SHARED_MEM_FOR_SYNC_TOP;
  shared_memory_end = (unsigned int*) SHARED_MEM_FOR_SYNC_BOTTOM;
  shared_memory_freearea = shared_memory_address;
  shared_addr_allocate_start_flag = 1;
}

void *shared_addr_for_sync_allocate(unsigned int size)
{
  unsigned int *val;

  if ( size <= 0 )
	return NULL;
  if ( shared_addr_allocate_start_flag == 0 )
	shared_addr_for_sync_allocate_init();

  if ( shared_memory_freearea + size < shared_memory_end ) {
	val = shared_memory_freearea;
	shared_memory_freearea += size;
	return val;
  } else {
	printf("\nout of shared memory!!!\n");
	exit(0);
  }	
}
