dnl Checks for package, version.
dnl CF_CHECK_VERSION(VERSION-FILE-NAME)
AC_DEFUN(CF_CHECK_VERSION, [
	AC_CACHE_CHECK(version file location, cf_cv_path_version_file, [
		if test -f ${srcdir}/$1; then
			cf_cv_path_version_file=${srcdir}/$1
		else
			cf_cv_path_version_file=`find ${srcdir} -name $1 | head -1`
		fi
	])
	if test -z "$cf_cv_path_version_file"; then
		AC_MSG_ERROR(Missing version file.)
	fi
	AC_CACHE_CHECK(package name, cf_cv_subst_package_name, [
		cf_cv_subst_package_name="`sed -n 's/^\([[a-zA-Z0-9_.]][[a-zA-Z0-9_.]]*\) *version.*$/\1/p' $cf_cv_path_version_file`"
		if test -z "$cf_cv_subst_package_name"; then
			AC_MSG_ERROR(Bad version file.)
		fi
	])
	PACKAGE="$cf_cv_subst_package_name"
	AC_CACHE_CHECK(version number, cf_cv_subst_version_number, [
		cf_cv_subst_version_number="`sed -n 's/^.*version *\([[0-9.]][[0-9.]]*\).*$/\1/p' $cf_cv_path_version_file`"
		if test -z "$cf_cv_subst_version_number"; then
			AC_MSG_ERROR(Bad version file.)
		fi
	])
	VERSION="$cf_cv_subst_version_number"
	dnl don't use cache for revision: revision is frequently updated
	AC_MSG_CHECKING(revision string)
	REVISION="`sed -n 's/^.*version.*(\(.*\))/\1/p' $cf_cv_path_version_file`"
	test -z "$REVISION" && REVISION=release
	AC_MSG_RESULT($REVISION)
	MAJOR_VERSION=`echo $VERSION | sed -n 's/^\([[0-9]][[0-9]]*\).*/\1/p'`
	MINOR_VERSION=`echo $VERSION | sed -n 's/^[[0-9]][[0-9]]*\.\([[0-9]][[0-9]]*\).*/\1/p'`
	MICRO_VERSION=`echo $VERSION | sed -n 's/^[[0-9]][[0-9]]*\.[[0-9]][[0-9]]*\.\([[0-9]][[0-9]]*\).*/\1/p'`
	test -z "$MICRO_VERSION" && MICRO_VERSION=0
	MAJOR_VERSION=`expr $MAJOR_VERSION + 0`
	MINOR_VERSION=`expr $MINOR_VERSION + 0`
	MICRO_VERSION=`expr $MICRO_VERSION + 0`
	AC_SUBST(PACKAGE)
	AC_SUBST(VERSION)
	AC_SUBST(REVISION)
	AC_SUBST(MAJOR_VERSION)
	AC_SUBST(MINOR_VERSION)
	AC_SUBST(MICRO_VERSION)
])

dnl set variables for libtool versioning.
dnl CF_SET_LT_VERSION(MAJOR_VERSION, MINOR_VERSION, MICRO_VERSION [, INTERFACE_AGE [, BINARY_AGE]])
AC_DEFUN(CF_SET_LT_VERSION, [
	AC_MSG_CHECKING(library version)
	major_version=$1
	minor_version=$2
	micro_version=$3
	interface_age=ifelse([$4],,[$3],[$4])
	binary_age=ifelse([$5],,[$3],[$5])
	LT_RELEASE=$major_version.$minor_version
	LT_CURRENT=`expr $micro_version - $interface_age`
	LT_REVISION=$interface_age
	LT_AGE=`expr $binary_age - $interface_age`
	AC_MSG_RESULT([release $LT_RELEASE, version-info ${LT_CURRENT}:${LT_REVISION}:${LT_AGE}])
	AC_SUBST(LT_RELEASE)
	AC_SUBST(LT_CURRENT)
	AC_SUBST(LT_REVISION)
	AC_SUBST(LT_AGE)
])

dnl Checks for option for specified command.
dnl CF_CHECK_OPTION(PROGRAM-VARIABLE, FLAG-VARIABLE, OPTION)
AC_DEFUN(CF_CHECK_OPTION, [
	changequote(<<,>>)dnl
	define(<<cacheval>>, translit(cf_cv_prog_$1_$3, +-, P_))dnl
	changequote([,])dnl
	AC_CACHE_CHECK(whether [$]$1 accepts $3, cacheval, [
		echo 'int main(void) { return 0; }' > conftest.$ac_ext
		if test -z "`[$]$1 [$]$2 $3 -c conftest.$ac_ext 2>&1`"; then
			cacheval=yes
		else
			cacheval=no
		fi
		rm -fr conftest*
	])
	if test x$cacheval = xyes; then
		if test ! x"`echo [$]$2 | sed -n 's,.*$3.*,x,p'`" = xx; then
			$2="[$]$2 $3"
		fi
	fi
])

dnl Checks for accept() 3rd argument type.
AC_DEFUN(CF_CHECK_ACCEPT_THIRD_ARG, [
	AC_CACHE_CHECK(whether accept 3rd arg is unsigned, cf_cv_func_accept_arg, [
		AC_TRY_COMPILE([
#if HAVE_SYS_TYPES_H
# include <sys/types.h>
#endif
#if HAVE_SYS_SOCKET_H
# include <sys/socket.h>
#endif
		]ifelse(AC_LANG, CPLUSPLUS, [
#ifdef __cplusplus
extern "C"
#endif
		]),[ struct sockaddr a; int b; accept(0, &a, &b); ],
		eval "cf_cv_func_accept_arg=no", eval "cf_cv_func_accept_arg=yes")
	])
	if test x"$cf_cv_func_accept_arg" = xyes; then
		AC_DEFINE_UNQUOTED(ACCEPT_THIRD_ARG_IS_UNSIGNED)
	fi
])

dnl Checks for recvfrom() 6th argument type.
AC_DEFUN(CF_CHECK_RECVFROM_SIXTH_ARG, [
	AC_CACHE_CHECK(whether recvfrom 6th arg is unsigned,
								 cf_cv_func_recvfrom_arg, [
		AC_TRY_COMPILE([
#if HAVE_SYS_TYPES_H
# include <sys/types.h>
#endif
#if HAVE_SYS_SOCKET_H
# include <sys/socket.h>
#endif
		]ifelse(AC_LANG, CPLUSPLUS, [
#ifdef __cplusplus
extern "C"
#endif
		]),[ struct sockaddr a; int b; char c; recvfrom(0, &c, 1, 0, &a, &b); ],
		eval "cf_cv_func_recvfrom_arg=no", eval "cf_cv_func_recvfrom_arg=yes")
	])
	if test x"$cf_cv_func_recvfrom_arg" = xyes; then
		AC_DEFINE_UNQUOTED(RECVFROM_SIXTH_ARG_IS_UNSIGNED)
	fi
])

dnl Checks for fpsetmask function.
AC_DEFUN(CF_CHECK_FPSETMASK, [
	AC_CACHE_CHECK(for fpsetmask, cf_cv_func_fpsetmask, [
		AC_TRY_LINK([
#if HAVE_FLOATINGPOINT_H
# include <floatingpoint.h>
#endif /* HAVE_FLOATINGPOINT_H */
#if HAVE_IEEEFP_H
# include <ieeefp.h>
#endif /* HAVE_IEEEFP_H */
		]ifelse(AC_LANG, CPLUSPLUS, [
#ifdef __cplusplus
extern "C"
#endif
		]),
		[fpsetmask(0);],
		eval "cf_cv_func_fpsetmask=yes", eval "cf_cv_func_fpsetmask=no")
	])
	if test x"$cf_cv_func_fpsetmask" = xyes; then
		AC_DEFINE_UNQUOTED(HAVE_FPSETMASK)
	fi
])

dnl Checks for htons function.
AC_DEFUN(CF_CHECK_HTONS, [
	AC_CACHE_CHECK(for htons, cf_cv_func_htons, [
		AC_TRY_LINK([
#if HAVE_UNISTD_H
# include <unistd.h>
#endif /* HAVE_UNISTD_H */
#if HAVE_NETINET_IN_H
# include <netinet/in.h>
#endif /* HAVE_NETINET_IN_H */
#if HAVE_SYS_PARAM_H
# include <sys/param.h>
#endif /* HAVE_SYS_PARAM_H */
		]ifelse(AC_LANG, CPLUSPLUS, [
#ifdef __cplusplus
extern "C"
#endif
		]), [htons(0);],
		eval "cf_cv_func_htons=yes", eval "cf_cv_func_htons=no")
	])
	if test x"$cf_cv_func_htons" = xyes; then
		AC_DEFINE_UNQUOTED(HAVE_HTONS)
	fi
])

dnl Checks for math function.
dnl CF_CHECK_MATH_FUNC(FUNCTION-NAME)
AC_DEFUN(CF_CHECK_MATH_FUNC, [
	AC_CACHE_CHECK(for $1, cf_cv_func_$1, [
		AC_TRY_LINK([
#include <math.h>
		],[$1($2);],
		eval "cf_cv_func_$1=yes", eval "cf_cv_func_$1=no")
	])
	if test x"$cf_cv_func_$1" = xyes; then
		ac_tr_func=HAVE_`echo $1 | tr 'abcdefghijklmnopqrstuvwxyz' 'ABCDEFGHIJKLMNOPQRSTUVWXYZ'`
		AC_DEFINE_UNQUOTED($ac_tr_func)
		ifelse([$3], , :, [$3])
	else
		ifelse([$4], , :, [$4])
	fi
])

dnl IM_PATH_PERLV_PROG(VARIABLE, PROG-TO-CHECK-FOR [, VALUE-IF-NOT-FOUND
dnl     [, PATH]])
AC_DEFUN(IM_PATH_PERLV_PROG,
[# Extract the first word of "$2", so it can be a program name with args.
set dummy $2; ac_word=[$]2
AC_MSG_CHECKING([for $ac_word])
AC_CACHE_VAL(im_cv_path_$1,
[case "[$]$1" in
	/*)
	im_cv_path_$1="[$]$1" # Let the user override the test with a path.
	;;
	*)
	IFS="${IFS=   }"; ac_save_ifs="$IFS"; IFS="${IFS}:"
	for ac_dir in ifelse([$4], , $PATH, [$4$ac_dummy]); do
		test -z "$ac_dir" && ac_dir=.
		if test -x $ac_dir/$ac_word; then
			if $ac_dir/$ac_word -e 'require 5.004;' > /dev/null 2>&1; then
				im_cv_path_$1="$ac_dir/$ac_word"
				break
			fi
		fi
	done
	IFS="$ac_save_ifs"
ifelse([$3], , , [  test -z "[$]im_cv_path_$1" && im_cv_path_$1="$3"
])dnl
	;;
esac])dnl
$1="$im_cv_path_$1"
if test -n "[$]$1"; then
	AC_MSG_RESULT([$]$1)
else
	AC_MSG_RESULT(no)
fi
AC_SUBST($1)dnl
])

dnl IM_PATH_PERLV_PROGS(VARIABLE, PROGS-TO-CHECK-FOR [, VALUE-IF-NOT-FOUND
dnl     [, PATH]])
AC_DEFUN(IM_PATH_PERLV_PROGS,
[for ac_prog in $2; do
IM_PATH_PERLV_PROG($1, [$]ac_prog, , $4)
test -n "[$]$1" && break
$1=""
done
ifelse([$3], , , [test -n "[$]$1" || $1="$3"
])])

dnl Local Variables:
dnl tab-width: 2
dnl End:
