/*
 * <<< directmap_cache_test.cc >>>
 *
 * --- Test program for directmap_cache class
 *     Copyright (C) 2000 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#include <iostream>
#include "simple_cache_line.h"
#include "directmap_cache.h"

typedef unsigned int word;
typedef simple_cache_line<word, word> cache_line_t;
typedef directmap_cache<cache_line_t> cache_t;

int main(void)
{
	const int cache_size = 0x100, line_size = 0x10;
	cache_t cc(cache_size, line_size);
	cout << cc << endl;
	for (word adr = 0; adr < cache_size * 2; adr += sizeof(word)) {
		cc.write(adr, adr);
	}
	cout << cc << endl;
	return 0;
}
