/* -*- C++ -*-
 *
 * <<< instruction_buffer.h >>>
 *
 * --- Fixed instruction buffer class 'instruction_buffer'
 *     Copyright (C) 1995-1999 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#ifndef INSTRUCTION_BUFFER_H
#define INSTRUCTION_BUFFER_H 1

#include <vector>
#include "root_object.h"

template < class T, class C = vector<T> >
class instruction_buffer : public root_object
{
public:
	typedef C container_type;
	typedef typename C::value_type value_type;
	typedef typename C::size_type size_type;
	typedef typename C::reference reference;
	typedef typename C::const_reference const_reference;
private:
	typedef instruction_buffer<T, C> thisclass;
	typedef root_object inherited;
	C buf;
	size_type stage_pointer;
public:
	instruction_buffer(void);
	explicit instruction_buffer(size_type);
	instruction_buffer(const thisclass&);
	virtual ~instruction_buffer();
	size_type size(void) const { return buf.size(); }
	const_reference operator[](size_type i) const
		{ return buf[(i >= stage_pointer) ?
					 (i - stage_pointer) : (size() + i - stage_pointer)]; }
	reference operator[](size_type i)
		{ return buf[(i >= stage_pointer) ?
					 (i - stage_pointer) : (size() + i - stage_pointer)]; }
	void clear(void);
	void step(void) { if (++stage_pointer >= size()) stage_pointer = 0; }
};

template <class T, class C>
instruction_buffer<T, C>::instruction_buffer(void)
{
	clear();
}

template <class T, class C>
instruction_buffer<T, C>::instruction_buffer
	(instruction_buffer<T, C>::size_type a)
	: buf(a)
{
	clear();
}

template <class T, class C>
instruction_buffer<T, C>::instruction_buffer
	(const instruction_buffer<T, C>& a)
	: buf(a.buf),
	  stage_pointer(a.stage_pointer)
{}

template <class T, class C>
instruction_buffer<T, C>::~instruction_buffer()
{}

template <class T, class C>
void instruction_buffer<T, C>::clear(void)
{
	typedef typename container_type::iterator IT;
	for (IT p = buf.begin(); p != buf.end(); p++) p->clear();
	stage_pointer = 0;
}

#endif /* INSTRUCTION_BUFFER_H */
