/*
 * <<< packet_buffer_test.cc >>>
 *
 * --- Test program for packet_buffer class
 *     Copyright (C) 2000 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#include "bus_packet.h"
#include "packet_buffer.h"

int main(void)
{
	typedef bus_packet<int> packet_t;
	packet_t* p = new packet_t;
	p->address() = 0;
	packet_buffer<packet_t> buf;
	const int count = 100;
	for (int i = 0; i < count; i++) {
		buf.put(p);
		p = buf.get();
		p->address()++;
	}
	bool flag = (p->address() == count);
	delete p;
	return flag ? 0 : 1;
}
