/*
 * <<< register_file_test.cc >>>
 *
 * --- Test program for register_file class
 *     Copyright (C) 2000 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#include "register_file.h"

int main(void)
{
	typedef unsigned int data_type;
	const size_t size = 32;
	typedef register_file<data_type> container_type;
	typedef container_type::size_type size_type;
	container_type rf(size);
	size_type i;
	for (i = 1; i < rf.size(); i++) {
		if (rf[i] != rf[0]) return 1;
		rf[i] = rf[i - 1] + 1;
	}
	for (i = rf.size() - 2; ; i--) {
		if (rf[i] != rf[i + 1] - 1) return 1;
		if (i == 0) break;
	}
	return 0;
}
