/*
 * <<< bus_packet_test.cc >>>
 *
 * --- Test program for bus_packet class
 *     Copyright (C) 2000 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#include <iostream>
#include "bus_packet.h"

typedef unsigned int word;
typedef bus_packet_base<word> bpkt_t;
typedef bus_packet<word> pkt_t;

void check(const pkt_t&);
void bcheck(const bpkt_t&);

int main(void)
{
	pkt_t* pkt;
	word adr = 1, dat = 0x1000;

#define CHK_PKT(mes, func) \
	cout << "=== " mes " - "; \
	pkt = new pkt_t; \
	pkt->func; \
	cout << *pkt << endl; \
	cout << "- bus_packet -" << endl; \
	check(*pkt); \
	cout << "- bus_packet_base -" << endl; \
	bcheck(*pkt); \
	delete pkt;

	CHK_PKT("single read request",  set_single_read_request(adr++));
	CHK_PKT("single read grant",    set_single_read_grant());
	CHK_PKT("single read ack",      set_single_read_ack());
	CHK_PKT("single read nack",     set_single_read_nack());
	CHK_PKT("single read data",     set_single_read_data(dat++));
	CHK_PKT("single write request", set_single_write_request(adr++));
	CHK_PKT("single write grant",   set_single_write_grant());
	CHK_PKT("single write ack",     set_single_write_ack());
	CHK_PKT("single write nack",    set_single_write_nack());
	CHK_PKT("single write data",    set_single_write_data(dat++));
	CHK_PKT("multi read request",   set_multi_read_request(adr++, 4));
	CHK_PKT("multi read grant",     set_multi_read_grant());
	CHK_PKT("multi read ack",       set_multi_read_ack());
	CHK_PKT("multi read nack",      set_multi_read_nack());
	CHK_PKT("multi read data",      set_multi_read_data(dat++, 4, 1));
	CHK_PKT("multi write request",  set_multi_write_request(adr++, 4));
	CHK_PKT("multi write grant",    set_multi_write_grant());
	CHK_PKT("multi write ack",      set_multi_write_ack());
	CHK_PKT("multi write nack",     set_multi_write_nack());
	CHK_PKT("multi write data",     set_multi_write_data(dat++, 4, 1));

	return 0;
}

#define CHK(mes, func) cout << mes << (a.func() ? "yes" : "no") << endl

void check(const pkt_t& a)
{
	CHK("is_single:               ", is_single);
	CHK("is_multi:                ", is_multi);
	CHK("is_read:                 ", is_read);
	CHK("is_write:                ", is_write);
	CHK("is_request:              ", is_request);
	CHK("is_grant:                ", is_grant);
	CHK("is_ack:                  ", is_ack);
	CHK("is_nack:                 ", is_nack);
	CHK("is_data:                 ", is_data);
	CHK("is_read_request:         ", is_read_request);
	CHK("is_read_grant:           ", is_read_grant);
	CHK("is_read_ack:             ", is_read_ack);
	CHK("is_read_nack:            ", is_read_nack);
	CHK("is_read_data:            ", is_read_data);
	CHK("is_write_request:        ", is_write_request);
	CHK("is_write_grant:          ", is_write_grant);
	CHK("is_write_ack:            ", is_write_ack);
	CHK("is_write_nack:           ", is_write_nack);
	CHK("is_write_data:           ", is_write_data);
	CHK("is_single_read_request:  ", is_single_read_request);
	CHK("is_single_read_grant:    ", is_single_read_grant);
	CHK("is_single_read_ack:      ", is_single_read_ack);
	CHK("is_single_read_nack:     ", is_single_read_nack);
	CHK("is_single_read_data:     ", is_single_read_data);
	CHK("is_single_write_request: ", is_single_write_request);
	CHK("is_single_write_grant:   ", is_single_write_grant);
	CHK("is_single_write_ack:     ", is_single_write_ack);
	CHK("is_single_write_nack:    ", is_single_write_nack);
	CHK("is_single_write_data:    ", is_single_write_data);
	CHK("is_multi_read_request:   ", is_multi_read_request);
	CHK("is_multi_read_grant:     ", is_multi_read_grant);
	CHK("is_multi_read_ack:       ", is_multi_read_ack);
	CHK("is_multi_read_nack:      ", is_multi_read_nack);
	CHK("is_multi_read_data:      ", is_multi_read_data);
	CHK("is_multi_write_request:  ", is_multi_write_request);
	CHK("is_multi_write_grant:    ", is_multi_write_grant);
	CHK("is_multi_write_ack:      ", is_multi_write_ack);
	CHK("is_multi_write_nack:     ", is_multi_write_nack);
	CHK("is_multi_write_data:     ", is_multi_write_data);
}

void bcheck(const bpkt_t& a)
{
	CHK("is_single:               ", is_single);
	CHK("is_multi:                ", is_multi);
	CHK("is_read:                 ", is_read);
	CHK("is_write:                ", is_write);
	CHK("is_request:              ", is_request);
	CHK("is_grant:                ", is_grant);
	CHK("is_ack:                  ", is_ack);
	CHK("is_nack:                 ", is_nack);
	CHK("is_data:                 ", is_data);
	CHK("is_read_request:         ", is_read_request);
	CHK("is_read_grant:           ", is_read_grant);
	CHK("is_read_ack:             ", is_read_ack);
	CHK("is_read_nack:            ", is_read_nack);
	CHK("is_read_data:            ", is_read_data);
	CHK("is_write_request:        ", is_write_request);
	CHK("is_write_grant:          ", is_write_grant);
	CHK("is_write_ack:            ", is_write_ack);
	CHK("is_write_nack:           ", is_write_nack);
	CHK("is_write_data:           ", is_write_data);
	CHK("is_single_read_request:  ", is_single_read_request);
	CHK("is_single_read_grant:    ", is_single_read_grant);
	CHK("is_single_read_ack:      ", is_single_read_ack);
	CHK("is_single_read_nack:     ", is_single_read_nack);
	CHK("is_single_read_data:     ", is_single_read_data);
	CHK("is_single_write_request: ", is_single_write_request);
	CHK("is_single_write_grant:   ", is_single_write_grant);
	CHK("is_single_write_ack:     ", is_single_write_ack);
	CHK("is_single_write_nack:    ", is_single_write_nack);
	CHK("is_single_write_data:    ", is_single_write_data);
	CHK("is_multi_read_request:   ", is_multi_read_request);
	CHK("is_multi_read_grant:     ", is_multi_read_grant);
	CHK("is_multi_read_ack:       ", is_multi_read_ack);
	CHK("is_multi_read_nack:      ", is_multi_read_nack);
	CHK("is_multi_read_data:      ", is_multi_read_data);
	CHK("is_multi_write_request:  ", is_multi_write_request);
	CHK("is_multi_write_grant:    ", is_multi_write_grant);
	CHK("is_multi_write_ack:      ", is_multi_write_ack);
	CHK("is_multi_write_nack:     ", is_multi_write_nack);
	CHK("is_multi_write_data:     ", is_multi_write_data);
}
