/*
 * <<< r3000_write_buffer_unit.cc >>>
 *
 * --- R3000 write buffer class 'r3000_write_buffer_unit'
 *     Copyright (C) 1995-1999 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#include <cstring> // needed only for SGI C++ compiler
#include <iomanip> // needed only for SGI C++ compiler
#include <iostream>
#include "r3000_write_buffer_unit.h"

r3000_write_buffer_unit::r3000_write_buffer_unit(r3000_memory_access_unit& a)
	: ma(a),
	  state(READY)
{}

r3000_write_buffer_unit::r3000_write_buffer_unit
	(const r3000_write_buffer_unit& a, r3000_memory_access_unit& b)
	: ma(b),
	  buf(a.buf),
	  state(a.state)
{}

r3000_write_buffer_unit::~r3000_write_buffer_unit()
{}

r3000_write_buffer_unit r3000_write_buffer_unit::operator=
	(const r3000_write_buffer_unit& a)
{
	if (this != &a) {
		ma = a.ma;
		buf = a.buf;
		state = a.state;
	}
	return *this;
}

void r3000_write_buffer_unit::reset(void)
{
	buf.clear();
	state = READY;
}

void r3000_write_buffer_unit::output(ostream& os) const
{
	if (ready()) {
		os << "ready(" << buf << ')';
	} else {
		os << "busy(" << buf << ')';
	}
#ifdef DEBUG
	os.flush();
#endif // DEBUG
}

ostream& operator<<(ostream& os, const r3000_write_buffer_unit& wbuf)
{
	if (os) wbuf.output(os);
#ifdef DEBUG
	os.flush();
#endif // DEBUG
	return os;
}
