/* -*- C++ -*-
 *
 * <<< r3010.h >>>
 *
 * --- This file contains the declarations of R3010 class.
 *     Copyright (C) 1996-1999 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#ifndef R3010_H
#define R3010_H 1

#include <string>
#include "r3010_global.h"
#include "r3010_base.h"

class r3010_stage;
class r3010_forward;
template <class T> class forwarder;
template <class T> class freelist;
class r3010_fgrbuf;
class r3010_fcrbuf;
class r3010_csr;
class r3010_bus;
class r3010_add;
class r3010_mul;
class r3010_div;

class ostream;

class r3010 : public r3010_base
{
	friend class debug;
	static int is_dec_string(const string&);
	static int is_hex_string(const string&);
	bool check_arg( string, const char*, string* );
	void set_debug_level( string& );
	bool reg_command( string );
public:
	r3010() {};
	void reset() { r3010_base::reset(); }
	void set_args( int, char const * const * );
	void set_command( const char * );
	/* interface functions between R3000 and R3010 */
	bool instruction_fetch_p();
	void instruction_fetch( r3000_word );
	bool data_fetch_p();
	void clock();
	void data_fetch( r3000_word );
	bool data_out_p();
	r3000_word data_out();
	void data_out_ok();
	bool fpcond() const;
	/* human interface (?) */
	void show_all_fgr( ostream& os ) const { r3010_base::show_all_fgr( os ); }
	void show_all_fcr( ostream& os ) const { r3010_base::show_all_fcr( os ); }
	r3000_word get_fgr( int regnum ) const;
	r3000_word get_fcr( int regnum ) const;
	void set_fgr( int, r3000_word );
	void set_fcr( int, r3000_word );
	friend ostream& operator<<( ostream&, const r3010& );
};

ostream& operator<<( ostream&, const r3010& );

#endif /* R3010_H */
