/*
 * <<< r3010_alu.cc >>>
 *
 * --- Copyright (C) 1996-2000 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 *
 * С:
 *	 㳰ϰڤʤƤʤ
 *	 0ʤɤԤ ISIS Τ顼ߤ
 *	 NaN λνϤƤʤ
 */

#include <cstring> // needed only for SGI C++ compiler
#include <iomanip> // needed only for SGI C++ compiler
#include "r3010_fgr.h"
#include "r3010_fcr.h"
#include "r3010_forward.h"
#include "forwarder.h"
#include "r3010_inst.h"
#include "r3010_stage.h"
#include "r3010_float.h"
#include "r3010_add.h"
#include "r3010_ext.h"
#include "r3010.h"

void
r3010_stage::alu_clock()
{
	switch( alu_state ) {
	case alu_none:
		if( !inst.is_fpa() || !inst.is_calc() ) {
			alu_state = alu_next;
			goto skip;
		}
		switch( inst.fmt() ) {
		case FMT_S:
			calc_s();
			break;
		case FMT_D:
			calc_d();
			break;
		case FMT_W:
			calc_w();
			break;
		default:
			alu_timer = 0;
			break;
		}
		alu_state = alu_delay;

	case alu_delay:
		if( alu_timer > 0 ) {
			alu_timer--;
			break;
		}

		{
			if( valid[reg_dst] ) {
#ifdef DEBUG
				if( fpa->debug_level() & R3010_DEBUG_FORWARDING )
					cout << "ALU:: forward " <<
						idx[reg_dst] << "&" << (idx[reg_dst]^1) << endl;
#endif
				r3010_forward* f = new r3010_forward;
				f->regnum = idx[reg_dst];
				f->val = reg[reg_dst];
//				fpa->forward->put( f, 0 );
				forward_id[0] = fpa->forward->put( f );

				f = new r3010_forward;
				f->regnum = idx[reg_dst]^1;
				f->val = reg[reg_dst];
//				fpa->forward->put( f, 0 );
				forward_id[1] = fpa->forward->put( f );

				fpa->release_reg( idx[reg_dst] );
				fpa->release_reg( idx[reg_dst]^1 );
			}
			else {
			}
		}
		alu_state = alu_next;

	case alu_next:
	  skip:
		if( fpa->s_mem )
			break;

		alu_state = alu_wait_bus;

	case alu_wait_bus:
		if( pre_mem_exec() )
			alu_go_next();
		else {
#ifdef DEBUG
			if( fpa->debug_level() & R3010_DEBUG_STALL )
				cout << "ALU:bus operation failed, stall" << endl;
#endif
		}
		break;
	}
}

void
r3010_stage::alu_go_next()
{
	fpa->s_mem = this;
	fpa->s_alu = 0;

	stage = mem_stage;
}

void
r3010_stage::calc_s()
{
	alu_timer = 0;

	s_float s1, s2 = 0;
	s_float result;

	int sign, exp;
	r3000_word frac[2];

	d_float result_d;
	r3000_word frac_d[2];
	r3000_word result_w;
	int top, all;

	r3010_rm_t rm;

	s1 = reg[reg_src1].read_single( idx[reg_src1] );
	if( inst.use_src(reg_src2) )
		s2 = reg[reg_src2].read_single( idx[reg_src2] );
	rm = csr.round_mode();

	switch( inst.func() ) {
	  case FUNC_ADD:
		result = s1 + s2;
		reg[reg_dst].write_single( idx[reg_dst], result );
		fpa->ex_add().start( idx[reg_dst], reg[reg_dst], 2, need_stall );
		need_release = false;
		break;
	  case FUNC_SUB:
		result = s1 - s2;
		reg[reg_dst].write_single( idx[reg_dst], result );
		fpa->ex_add().start( idx[reg_dst], reg[reg_dst], 2, need_stall );
		need_release = false;
		break;
	  case FUNC_MUL:
		result = s1 * s2;
		reg[reg_dst].write_single( idx[reg_dst], result );
		fpa->ex_mul().start( idx[reg_dst], reg[reg_dst], FMT_S, need_stall );
		need_release = false;
		break;
	  case FUNC_DIV:
		result = s1 / s2;
		reg[reg_dst].write_single( idx[reg_dst], result );
		fpa->ex_div().start( idx[reg_dst], reg[reg_dst], FMT_S, need_stall );
		need_release = false;
		break;
	  case FUNC_ABS:
		if( s1 < (s_float)0.0 )
			result = -s1;
		else
			result = s1;
		reg[reg_dst].write_single( idx[reg_dst], result );
		valid[reg_dst] = true;
		break;
	  case FUNC_MOV:
		result = s1;
		reg[reg_dst].write_single( idx[reg_dst], result );
		valid[reg_dst] = true;
		break;
	  case FUNC_NEG:
		result = -s1;
		reg[reg_dst].write_single( idx[reg_dst], result );
		valid[reg_dst] = true;
		break;

	  case FUNC_CVT_S:
		/* ̤̿(EX\_E)ȯʤФʤʤ */
		result = s1;
		break;

	  case FUNC_CVT_D:
		  if( s1 == 0.0 )
			  result_d = 0.0;
		  else {
			  sign = get_sign( s1 );
			  exp = get_exp( s1 );
			  get_frac( s1, frac );

			  frac_d[0] = frac[0] >> (SINGLE_FRAC_LEN - (DOUBLE_FRAC_LEN-32));
			  frac_d[1] = frac[0] << (DOUBLE_FRAC_LEN - SINGLE_FRAC_LEN);

			  make_double( result_d, sign, exp, frac_d );
		  }
		reg[reg_dst].write_double( result_d );
		valid[reg_dst] = true;
		break;

	  case FUNC_CVT_W:
		alu_timer = 2;

		sign = get_sign( s1 );
		exp = get_exp( s1 );
		get_frac( s1, frac );

		if( exp == EXP_ZERO )
			result_w = 0;
		else if( exp == EXP_INFINITY ) {
			/* ϥСե㳰 */
			result_w = sign ? R3010_INT_MIN : R3010_INT_MAX;
		}
		else if( exp >= R3010_INT_NBIT ) {
			/* ϥСե㳰 */
			result_w = sign ? R3010_INT_MIN : R3010_INT_MAX;
		}
		else if( exp < -1 ) {
			result_w = 0;
		}
		else {
			result_w = frac[0] >> (SINGLE_FRAC_LEN - exp);
			if( exp >= 0 )
				result_w |= 1 << exp;

			frac[0] <<= (8 * sizeof_r3000_word + exp - SINGLE_FRAC_LEN);
			top = frac[0] & (1<<(8 * sizeof_r3000_word)-1) != 0;
			all = frac[0] != 0;

			switch( rm ) {
			  case ROUND_TO_NEAREST:
				result_w += top;
				break;
			  case ROUND_TO_ZERO:
				break;
			  case ROUND_TO_PLUS_INFINITY:
				if( !sign )
					result_w += all;
				break;
			  case ROUND_TO_MINUS_INFINITY:
				if( sign )
					result_w += all;
				break;
			}

			if( sign && result_w == R3010_INT_MIN )
				;
#if 0
			else if( result_w > R3010_INT_MAX )
				result_w = R3010_INT_MAX;
#endif
			else if( sign )
					result_w = ~result_w + 1;
		}

		reg[reg_dst].write_word( idx[reg_dst], result_w );
//		fpa->ex_add().external( 2, reg[reg_dst], idx[reg_dst], need_stall );
		fpa->ex_add().start( idx[reg_dst], reg[reg_dst], 2, need_stall );
		alu_timer = 0;
		need_release = false;
		break;
	  default:
		if( inst.func() >= FUNC_C_F ) { // compair
			bool less, equal, unordered;
			int cond = inst.func() & (COND_LESS | COND_EQUAL | COND_UNORDERED);

			unordered = false;
			less = s1 < s2;
			equal = s1 == s2;

			_fpcond.valid = true;
			_fpcond.flag = ((cond & COND_LESS) && less)
				| ((cond & COND_EQUAL) && equal)
				| ((cond & COND_UNORDERED) && unordered);
		}
		else {
			/* ̤̿(EX\_E)ȯʤФʤʤ */
		}
		break;
	}
}

void
r3010_stage::calc_d()
{
	alu_timer = 0;

	d_float s1, s2 = 0;
	d_float result;
	int top;
	int all;
	r3010_rm_t rm;

	int sign, exp;
	r3000_word frac[2];

	s1 = reg[reg_src1].read_double();
	if( inst.use_src(reg_src2) )
		s2 = reg[reg_src2].read_double();
	rm = csr.round_mode();

	switch( inst.func() ) {
	case FUNC_ADD:
		result = s1 + s2;
		reg[reg_dst].write_double( result );
		fpa->ex_add().start( idx[reg_dst], reg[reg_dst], 2, need_stall );
		need_release = false;
		break;
	case FUNC_SUB:
		result = s1 - s2;
		reg[reg_dst].write_double( result );
		fpa->ex_add().start( idx[reg_dst], reg[reg_dst], 2, need_stall );
		need_release = false;
		break;
	case FUNC_MUL:
		result = s1 * s2;
		reg[reg_dst].write_double( result );
		fpa->ex_mul().start( idx[reg_dst], reg[reg_dst], FMT_D, need_stall );
		need_release = false;
		break;
	case FUNC_DIV:
		result = s1 / s2;
		reg[reg_dst].write_double( result );
		fpa->ex_div().start( idx[reg_dst], reg[reg_dst], FMT_D, need_stall );
		need_release = false;
		break;
	case FUNC_ABS:
		if( s1 < (s_float)0.0 )
			result = -s1;
		else
			result = s1;
		reg[reg_dst].write_double( result );
		valid[reg_dst] = true;
		break;
	case FUNC_MOV:
		result = s1;
		reg[reg_dst].write_double( result );
		valid[reg_dst] = true;
		break;
	case FUNC_NEG:
		result = -s1;
		reg[reg_dst].write_double( result );
		valid[reg_dst] = true;
		break;

	case FUNC_CVT_S:
		{
			s_float result_s;
			alu_timer = 1;

			if( s1 == 0.0 )
				result_s = 0.0;
			else {
				sign = get_sign( s1 );
				exp = get_exp( s1 );
				get_frac( s1, frac );

				r3000_word frac_s;

				frac_s = (frac[0] << (SINGLE_FRAC_LEN-(DOUBLE_FRAC_LEN-32))) |
					(frac[1] >> (DOUBLE_FRAC_LEN - SINGLE_FRAC_LEN));
				// ϴݤ⡼ɤˤäƲ +1, -1 ɬפ

				make_single( result_s, sign, exp, frac_s );
			}
			reg[reg_dst].write_single( idx[reg_dst], result_s );
			fpa->ex_add().start( idx[reg_dst], reg[reg_dst], alu_timer+1, need_stall );
			alu_timer = 0;
		}
		break;

	case FUNC_CVT_D:
		// ̤̿(EX\_E)㳰ˤʤ
		result = s1;
		break;

	case FUNC_CVT_W:
		alu_timer = 2;

		sign = get_sign( s1 );
		exp = get_exp( s1 );
		get_frac( s1, frac );

		r3000_word result_w;

		if( exp == EXP_ZERO ) {
			result_w = 0;
		}
		else if( exp == EXP_INFINITY ) {
			/* ϥСե */
			result_w = sign ? R3010_INT_MIN : R3010_INT_MAX;
		}
		else if( exp >= R3010_INT_NBIT ) {
			/* ϥСե㳰 */
			result_w = sign ? R3010_INT_MIN : R3010_INT_MAX;
		}
		else if( exp < -1 )
			result_w = 0;
		else {
			if( DOUBLE_FRAC_LEN - exp >= R3010_INT_NBIT ) {
				result_w = frac[0] >> (DOUBLE_FRAC_LEN - exp - 32);
			}
			else {
				result_w = (frac[1] >> (DOUBLE_FRAC_LEN - exp))
					| (frac[0] << (32 - (DOUBLE_FRAC_LEN - exp)));
			}
			if( exp >= 0 )
				result_w |= 1 << exp;

			if( exp < int(DOUBLE_FRAC_LEN - 8 * sizeof_r3000_word) ) {
				frac[0] <<=
					(2 * (8 * sizeof_r3000_word) - DOUBLE_FRAC_LEN + exp);
				top = (frac[0] & (1 << (8 * sizeof_r3000_word - 1))) != 0;
				all = frac[0] || frac[1];
			}
			else {
				frac[1] <<= (8 * sizeof_r3000_word + exp - DOUBLE_FRAC_LEN);
				top = (frac[1] & (1 << (8 * sizeof_r3000_word - 1))) != 0;
				all = frac[1] != 0;
			}
			switch( rm ) {
			case ROUND_TO_NEAREST:
				result_w += top;
				break;
			case ROUND_TO_ZERO:
				break;
			case ROUND_TO_PLUS_INFINITY:
				if( !sign )
					result_w += all;
				break;
			case ROUND_TO_MINUS_INFINITY:
				if( sign )
					result_w += all;
				break;
			}

			if( sign && result_w == R3010_INT_MIN )
				;
#if 0
			else if( result_w > R3010_INT_MAX )
				;/* Сե */
#endif
			else if( result_w && sign )
					result_w = ~result_w + 1;
		}

		reg[reg_dst].write_word( idx[reg_dst], result_w );
//		fpa->ex_add().external( 2, reg[reg_dst], idx[reg_dst], need_stall );
		fpa->ex_add().start( idx[reg_dst], reg[reg_dst], 2, need_stall );
		alu_timer = 0;
		need_release = false;
		break;
	default:
		if( inst.func() >= FUNC_C_F ) { // compair
			bool less, equal, unordered;
			int cond = inst.func() & 007;

			unordered = false;
			less = s1 < s2;
			equal = s1 == s2;

			_fpcond.valid = true;
			_fpcond.flag = ((cond & COND_LESS) && less)
				| ((cond & COND_EQUAL) && equal)
				| ((cond & COND_UNORDERED) && unordered);
		}
		else {
			/* ̤̿(EX\_E)ȯʤФʤʤ */
		}
		break;
	}
}

void
r3010_stage::calc_w()
{
	alu_timer = 0;

	r3000_word s1, s2;

	s1 = reg[reg_src1].read_word( idx[reg_src1] );
	if( inst.use_src(reg_src2) )
		s2 = reg[reg_src2].read_word( idx[reg_src2] );

	switch( inst.func() ) {
	case FUNC_ADD:
	case FUNC_SUB:
	case FUNC_MUL:
	case FUNC_DIV:
	case FUNC_ABS:
	case FUNC_MOV:
	case FUNC_NEG:
		// ̤̿(EX\_E)㳰
		break;

	case FUNC_CVT_S:
		{
		alu_timer = 2;

		int sign, exp;
		r3000_word frac_s = 0;
		s_float result_s;

		if( s1 == 0 ) {
			sign = 0;
			exp = EXP_ZERO;
		}
		else {
			sign = s1 & R3010_INT_SIGN;
			if( sign )
				s1 = ~s1 + 1; // negate (but type of s1 is WORD)

			exp = top_one( s1 );

			frac_s = (s1 << (SINGLE_FRAC_LEN - exp))
				& SINGLE_FRAC_MASK;
		}

		make_single( result_s, sign, exp, frac_s );
		reg[reg_dst].write_single( idx[reg_dst], result_s );
		valid[reg_dst] = true;

//		fpa->ex_add().external( alu_timer, reg[reg_dst], idx[reg_dst], need_stall );
		fpa->ex_add().start( idx[reg_dst], reg[reg_dst], alu_timer+1, need_stall );
		alu_timer = 0;
		need_release = false;
		}
		break;

	case FUNC_CVT_D:
		{
		alu_timer = 2;

		int sign, exp;
		r3000_word frac_d[2];
		d_float result_d;

		if( s1 == 0 ) {
			sign = 0;
			exp = EXP_ZERO;
		}
		else {
			sign = s1 & R3010_INT_SIGN;
			if( sign )
				s1 = ~s1 + 1; // negate (but type of s1 is WORD)

			exp = top_one( s1 );

			if( (DOUBLE_FRAC_LEN - exp) >= 32 ) {
				frac_d[0] = (s1 << (DOUBLE_FRAC_LEN - 32 - exp))
					& DOUBLE_FRAC_HI_MASK;
				frac_d[1] = 0;
			}
			else {
				frac_d[0] = (s1 >> (32 - (DOUBLE_FRAC_LEN - exp)))
					& DOUBLE_FRAC_HI_MASK;
				frac_d[1] = s1 << (DOUBLE_FRAC_LEN - exp);
			}
		}

		make_double( result_d, sign, exp, frac_d );
		reg[reg_dst].write_double( result_d );

		valid[reg_dst] = true;
//		fpa->ex_add().external( alu_timer, reg[reg_dst], idx[reg_dst], need_stall );
		fpa->ex_add().start( idx[reg_dst], reg[reg_dst], alu_timer+1, need_stall );
		alu_timer = 0;
		need_release = 0;
		}
		break;

	case FUNC_CVT_W:
		// ̤̿(EX\_E)㳰
		break;
	default:
		/* ̤̿(EX\_E)ȯʤФʤʤ */
		break;
	}
}
