/*
 * <<< r3010_bus.h >>>
 *
 * --- Copyright (C) 1996-2000 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#include <cstring> // needed only for SGI C++ compiler
#include <iomanip> // needed only for SGI C++ compiler
#include <iostream>
#include "r3010_bus.h"

r3010_bus::r3010_bus()
{
}

// r3010_bus $B$N=i4|2=(B
void
r3010_bus::reset()
{
	dir = bus_free;
	valid = false;
}

// R3010 $BFbIt$+$i$N%G!<%?F~NO=`HwMW5a(B
bool
r3010_bus::data_request()
{
	if( dir != bus_free )
		return false;

	dir = bus_in;
	valid = false;

	return true;
}

// R3010 $BFbIt$+$i$N%G!<%?<h$j9~$_(B
bool
r3010_bus::data_read( r3000_word* w )
{
	if( dir != bus_in || valid == false )
		return false;
	*w = data;
	valid = false;
	dir = bus_free;
	return true;
}

// R3010 $BFbIt$+$i$N%G!<%?=PNOMW5a(B
bool
r3010_bus::data_out_request( r3000_word w )
{
	if( dir != bus_free )
		return false;

	data = w;
	dir = bus_out;
	valid = true;

	return true;
}

// R3000 $B$+$i$N%G!<%?E>AwMW5aD4::(B
bool
r3010_bus::data_fetch_p()
{
	return dir == bus_in && !valid;
}


// R3000 $B$+$i$N%G!<%?E>Aw(B
void
r3010_bus::data_fetch( r3000_word w )
{
	data = w;
	valid = true;
}

// R3000 $B$X$N%G!<%?E>AwMW5aD4::(B
bool
r3010_bus::data_out_p()
{
	return dir == bus_out && valid;
}

// R3000 $B$X$N%G!<%?E>Aw(B
r3000_word
r3010_bus::data_out()
{
	valid = false;

	return data;
}

// R3000 $B$X$N%G!<%?E>Aw40N;(B
void
r3010_bus::data_out_ok()
{
	dir = bus_free;
}

//
ostream& operator<<( ostream& os, const r3010_bus& bus )
{
	static char *direction[] = { "FREE", "IN", "OUT" };

	os << "{" << direction[bus.dir] << ", ";
	os << (bus.valid ? "VALID" : "INVALID");
	if( bus.valid )
		os << ":" << hex << bus.data << dec;
	os << "}";

	return os;
}
