/* -*- C++ -*-
 *
 * <<< r3010_fcr.h >>>
 *
 * --- Copyright (C) 1996-1999 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#ifndef R3010_FCR_H
#define R3010_FCR_H 1

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif
#include "r3010_global.h"
#include "r3010_float.h"

class r3010_base;

class r3010_fcr
{
	friend class debug;

protected:
	const r3010_base* fpa;
	r3000_word d;
public:
	r3010_fcr( const r3010_base* body ) : fpa( body ) { d = 0; }
	virtual void reset() {}

	virtual r3000_word read_word() { return d; }
	virtual void write_word( r3000_word ) {}
};

class r3010_rel : public r3010_fcr
{
public:
	r3010_rel( const r3010_base* );
};

#define		R3010_REL		0
#define		R3010_CSR		31

#define		R3010_CSR_COND_SHIFT		23
#define		R3010_CSR_EXC_SHIFT		12
#define		R3010_CSR_TRAP_SHIFT		7
#define		R3010_CSR_STICKY_SHIFT		2

#define		R3010_CSR_COND_MASK		0x1
#define		R3010_CSR_RM_MASK		0x3

#define		R3010_EXC_I		0x01
#define		R3010_EXC_U		0x02
#define		R3010_EXC_O		0x04
#define		R3010_EXC_Z		0x08
#define		R3010_EXC_V		0x10
#define		R3010_EXC_E		0x20
#define		R3010_EXC_ALL		0x3f
#define		R3010_EXC_MASKABLE		0x1f

class r3010_csr : public r3010_fcr
{
public:
	r3010_csr( const r3010_base* body ) : r3010_fcr( body ) {}
	void reset();

	void write_word( r3000_word );

	void set_exc( int );
	void set_cond( bool );
	bool exception();
	r3000_word get_exc_trap() const {
		return (d >> R3010_CSR_TRAP_SHIFT) & R3010_EXC_MASKABLE;
	}
	r3010_rm_t round_mode() const {
		return (r3010_rm_t)(d & R3010_CSR_RM_MASK);
	}
	bool fpcond() const {
		return (d >> R3010_CSR_COND_SHIFT) & R3010_CSR_COND_MASK;
	}
};

class r3010_fcrbuf
{
	r3010_fcr **fcr;
	r3010_rel *_rel;
	r3010_csr *_csr;

	friend class debug;
public:
	r3010_fcrbuf( const r3010_base* );
	void reset();

	r3010_rel*& rel() { return _rel; }
	r3010_csr*& csr() { return _csr; }

	r3000_word read_word( int regnum ) {
		return fcr[regnum]->read_word();
	}
	void write_word( int regnum, r3000_word data ) {
		fcr[regnum]->write_word( data );
	}
};

#endif /* R3010_FCR_H */
