/* -*- C++ -*-
 *
 * <<< r3010_float.h >>>
 *
 * --- Copyright (C) 1996-1999 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#ifndef R3010_FLOAT_H
#define R3010_FLOAT_H 1

#include "sysfloat.h"

#define R3010_INT_NBIT			31
#define R3010_INT_MAX			0x7fffffff
#define R3010_INT_MIN			0x80000000
#define R3010_INT_SIGN			0x80000000

#define SINGLE_SIGN_SHIFT		31
#define SINGLE_SIGN_LEN			1
#define SINGLE_SIGN_MASK		0x01

#define SINGLE_EXP_SHIFT		23
#define SINGLE_EXP_LEN			8
#define SINGLE_EXP_MASK			0xff
#define SINGLE_EXP_BASE			127
#define SINGLE_EXP_MAX			127
#define SINGLE_EXP_MIN			-126

#define SINGLE_FRAC_SHIFT		0
#define SINGLE_FRAC_LEN			23
#define SINGLE_FRAC_MASK		0x007fffff

#define DOUBLE_SIGN_SHIFT		63
#define DOUBLE_SIGN_LEN			1
#define DOUBLE_SIGN_MASK		0x1

#define DOUBLE_EXP_SHIFT		52
#define DOUBLE_EXP_LEN			11
#define DOUBLE_EXP_MASK			0x7ff
#define DOUBLE_EXP_BASE			1023
#define DOUBLE_EXP_MAX			1023
#define DOUBLE_EXP_MIN			-1022

#define DOUBLE_FRAC_SHIFT		0
#define DOUBLE_FRAC_LEN			52
/*
#define DOUBLE_FRAC_MASK		0xfffffffffffff
*/
#define DOUBLE_FRAC_HI_MASK		0xfffff
#define DOUBLE_FRAC_LO_MASK		0xffffffff

void r3010_word_to_single(r3000_word, s_float&);
void r3010_word_to_double(r3000_word*, d_float&);
void r3010_single_to_word(s_float, r3000_word&);
void r3010_double_to_word(d_float, r3000_word*);
void r3010_single_to_double(s_float*, d_float&);
void r3010_double_to_single(d_float, s_float*);

enum r3010_rm_t {
	ROUND_TO_NEAREST, ROUND_TO_ZERO,
	ROUND_TO_PLUS_INFINITY, ROUND_TO_MINUS_INFINITY
};

int top_one(r3000_word);

#endif /* R3010_FLOAT_H */
