/* -*- C++ -*-
 *
 * <<< r3010_inst.h >>>
 *
 * --- Copyright (C) 1996-1999 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#ifndef R3010_INST_H
#define R3010_INST_H 1

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif
#include "r3010_global.h"
#include "stage_inst.h"
#include "inst_op.h"

class ostream;

class r3010_inst
{
	r3000_word _inst;
	bool _have_inst;

	bool _use_reg[3];  /* index is reg_idx_t */
	int _regnum[3];	/* index is reg_idx_t */

	enum { ft, fs, fd };
	int _reg[3];	   /* index is enum { ft, fs, fd }; */

	op_t _op;
	bool _op25;
	sub_t _sub;
	br_t _br;   // not used in R3010 modules

	fmt_t _fmt;
	func_t _func;

	int _base;  // not used in R3010 modules
	unsigned int _offset; // not used in R3010 modules

	bool _fpa;
	bool _calc;

	bool _bus_from, _bus_to;

	void disasm_cop1(ostream &) const;

	friend class debug;
public:
	void reset();
	void decode( r3000_word );

	r3010_inst() { }
	r3010_inst( r3000_word w ) { reset(); decode( w ); }

	// -----------------------------------------------
	bool have_inst() const { return _have_inst; }
	bool use_src( reg_idx_t idx ) const { return _use_reg[idx]; }
	bool use_dst() const { return _use_reg[reg_dst]; }

	bool is_calc() const { return _calc; }
	bool is_fpa() const { return _fpa; }

	bool is_read() const { return _bus_from; }
	bool is_write() const { return _bus_to; }
	// -----------------------------------------------
	r3000_word inst() const { return _inst; }

	// bit 31..26
	op_t op() const { return _op; }

	// bit 25
	bool op25() const { return _op25; }

	// bit 24..21
	sub_t sub() const { return _sub; }
	br_t br() const { return _br; }
	fmt_t fmt() const { return _fmt; }

	// bit 5..0
	func_t func() const { return _func; }

	int src( reg_idx_t idx ) const { return _regnum[idx]; }
	int dst() const { return _regnum[reg_dst]; }

	// bit 25..21
	int base() const { return _base; }
	// bit 15..0
	unsigned int offset() const { return _offset; }

	// ------------------------------------------------
	char *disasm() const;
};

ostream& operator<<( ostream&, const r3010_inst& );

#endif /* R3010_INST_H */
