/* -*- C++ -*-
 *
 * <<< sysfloat.h >>>
 *
 * --- Copyright (C) 1996-1999 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#ifndef SYSFLOAT_H
#define SYSFLOAT_H 1

#include <climits>
#include "r3000_typedef.h"
#include "r3010_types.h"

#define EXP_INFINITY	INT_MAX
#define EXP_ZERO		INT_MIN

int get_sign(s_float);
int get_exp(s_float);
void get_frac(s_float, r3000_word[2]);
int get_sign(d_float);
int get_exp(d_float);
void get_frac(d_float, r3000_word[2]);
void make_single(s_float&, int /*sign*/, int /*exp*/, r3000_word /*frac*/);
void make_double(d_float&, int /*sign*/, int /*exp*/, r3000_word[2] /*frac*/);

#endif /* SYSFLOAT_H */
