/*
 * <<< sysfloat_test.cc >>>
 *
 * --- Test program for floating point calculation functions
 *     Copyright (C) 2000 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#include <cmath>
#include <cstdlib>
#include <iostream>
#include <iomanip>
#include "r3000_typedef.h"
#include "r3010_float.h"
#include "sysfloat.h"

#define rnd() ((unsigned)((seed = 1566083941UL * seed + 1) >> 16))
static unsigned long seed = 1;

double double_rand(void);
int single_test(int);
int double_test(int);

int main(int, char** argv)
{
	int count = ((argv[1] != NULL) ? atoi(argv[1]) : 100);
	return ((single_test(count) && double_test(count)) ? 0 : 1);
}

double double_rand(void)
{
	return double(((rnd() >> 8) << 8) | (rnd() >> 8)) - 0x8000;
}

int single_test(int count)
{
	union {
		s_float f;
		r3000_word w;
	} src, dst;
	s_float& x = src.f;
	r3000_word& x_word = src.w;
	s_float& y = dst.f;
	r3000_word& y_word = dst.w;
	for (int i = 0; i < count; i++) {
		x = double_rand();
		int sign, exp;
		r3000_word frac[2];
		sign = get_sign(x);
		exp = get_exp(x);
		get_frac(x, frac);
		make_single(y, sign, exp, frac[0]);
		if (x_word != y_word) {
			cout << dec << setfill(' ') << setw(8) << x
				 << ": 0x" << hex << setfill('0') << setw(8) << x_word
				 << " sign:" << (sign ? '-' : '+')
				 << " exp:" << dec << setfill('0') << setw(4) << exp
				 << " frac:0x" << hex << setfill('0') << setw(8) << frac[0]
				 << " y:" << dec << setfill(' ') << setw(8) << y
				 << "(0x" << hex << setfill('0') << setw(8) << y_word << ')'
				 << endl;
			return 0;
		}
	}
	return 1;
}

int double_test(int count)
{
	union {
		d_float f;
		r3000_word w[2];
	} src, dst;
	d_float& x = src.f;
	r3000_word& x_word_upper = src.w[1];
	r3000_word& x_word_lower = src.w[0];
	d_float& y = dst.f;
	r3000_word& y_word_upper = dst.w[1];
	r3000_word& y_word_lower = dst.w[0];
	for (int i = 0; i < count; i++) {
		x = double_rand();
		int sign, exp;
		r3000_word frac[2];
		sign = get_sign(x);
		exp = get_exp(x);
		get_frac(x, frac);
		make_double(y, sign, exp, frac);
		if (x_word_upper != y_word_upper || x_word_lower != y_word_lower) {
			cout << dec << setfill(' ') << setw(8) << x
				 << ": 0x" << hex << setfill('0') << setw(8) << x_word_upper
				 << setw(8) << x_word_lower
				 << " sign:" << (sign ? '-' : '+')
				 << " exp:" << dec << setfill('0') << setw(4) << exp
				 << " frac:0x" << hex << setfill('0') << setw(8) << frac[0]
				 << setw(8) << frac[1]
				 << " y:" << dec << setfill(' ') << setw(8) << y
				 << "(0x" << hex << setfill('0') << setw(8) << y_word_upper
				 << setw(8) << y_word_lower << ')'
				 << endl;
			return 0;
		}
	}
	return 1;
}
